/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http;

import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpResponse;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpResponseHandler;
import net.snowflake.client.jdbc.internal.amazonaws.internal.http.JsonErrorCodeParser;
import net.snowflake.client.jdbc.internal.amazonaws.transform.JsonErrorUnmarshallerV2;
import net.snowflake.client.jdbc.internal.amazonaws.util.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;

public class JsonErrorResponseHandlerV2
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(JsonErrorResponseHandlerV2.class);
    private final List<JsonErrorUnmarshallerV2> unmarshallers;
    private final JsonErrorCodeParser errorCodeParser;

    public JsonErrorResponseHandlerV2(List<JsonErrorUnmarshallerV2> errorUnmarshallers) {
        this(errorUnmarshallers, JsonErrorCodeParser.DEFAULT_ERROR_CODE_PARSER);
    }

    public JsonErrorResponseHandlerV2(List<JsonErrorUnmarshallerV2> errorUnmarshallers, JsonErrorCodeParser errorCodeParser) {
        this.unmarshallers = errorUnmarshallers;
        this.errorCodeParser = errorCodeParser;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent(response);
        String errorCode = this.errorCodeParser.parseErrorCode(response.getHeaders(), jsonContent.jsonNode);
        AmazonServiceException ase = this.createException(errorCode, jsonContent);
        ase.setErrorCode(errorCode);
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        ase.setErrorType(this.getErrorTypeFromStatusCode(response.getStatusCode()));
        ase.setRawResponseContent(jsonContent.rawJsonContent);
        String requestId = this.getRequestIdFromHeaders(response.getHeaders());
        if (requestId != null) {
            ase.setRequestId(requestId);
        }
        return ase;
    }

    private AmazonServiceException createException(String errorCode, JsonContent jsonContent) {
        if (!jsonContent.isJsonValid()) {
            return new AmazonServiceException("Unable to parse HTTP response content");
        }
        AmazonServiceException ase = this.unmarshallException(errorCode, jsonContent);
        if (ase == null) {
            ase = new AmazonServiceException("Unable to unmarshall exception response with the unmarshallers provided");
        }
        return ase;
    }

    private AmazonServiceException unmarshallException(String errorCode, JsonContent jsonContent) {
        for (JsonErrorUnmarshallerV2 unmarshaller : this.unmarshallers) {
            if (!unmarshaller.matchErrorCode(errorCode)) continue;
            try {
                return unmarshaller.unmarshall(jsonContent.jsonNode);
            }
            catch (Exception e) {
                LOG.info("Unable to unmarshall exception content", e);
                return null;
            }
        }
        return null;
    }

    private AmazonServiceException.ErrorType getErrorTypeFromStatusCode(int statusCode) {
        return statusCode < 500 ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service;
    }

    private String getRequestIdFromHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("x-amzn-RequestId")) continue;
            return headerEntry.getValue();
        }
        return null;
    }

    private static class JsonContent {
        private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        public final String rawJsonContent;
        public final JsonNode jsonNode;

        public static JsonContent createJsonContent(HttpResponse httpResponse) {
            String rawJsonContent = null;
            try {
                rawJsonContent = IOUtils.toString(httpResponse.getContent());
            }
            catch (Exception e) {
                LOG.info("Unable to read HTTP response content", e);
            }
            return new JsonContent(rawJsonContent);
        }

        private JsonContent(String rawJsonContent) {
            this.rawJsonContent = rawJsonContent;
            this.jsonNode = JsonContent.parseJsonContent(rawJsonContent);
        }

        private static JsonNode parseJsonContent(String rawJsonContent) {
            if (rawJsonContent == null) {
                return null;
            }
            try {
                return MAPPER.readTree(rawJsonContent);
            }
            catch (Exception e) {
                LOG.info("Unable to parse HTTP response content", e);
                return null;
            }
        }

        public boolean isJsonValid() {
            return this.jsonNode != null;
        }
    }
}

