/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.internal.http;

import java.util.Map;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;

public class JsonErrorCodeParser {
    public static final JsonErrorCodeParser DEFAULT_ERROR_CODE_PARSER = new JsonErrorCodeParser("__type");
    static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private final String errorCodeFieldName;

    public JsonErrorCodeParser(String errorCodeFieldName) {
        this.errorCodeFieldName = errorCodeFieldName;
    }

    public String parseErrorCode(Map<String, String> httpHeaders, JsonNode jsonContents) {
        String errorCodeFromHeader = this.parseErrorCodeFromHeader(httpHeaders);
        if (errorCodeFromHeader != null) {
            return errorCodeFromHeader;
        }
        return this.parseErrorCodeFromContents(jsonContents);
    }

    private String parseErrorCodeFromHeader(Map<String, String> httpHeaders) {
        int separator;
        String headerValue = httpHeaders.get(X_AMZN_ERROR_TYPE);
        if (headerValue != null && (separator = headerValue.indexOf(58)) != -1) {
            headerValue = headerValue.substring(0, separator);
        }
        return headerValue;
    }

    private String parseErrorCodeFromContents(JsonNode jsonContents) {
        if (jsonContents == null || !jsonContents.has(this.errorCodeFieldName)) {
            return null;
        }
        String code = jsonContents.findValue(this.errorCodeFieldName).asText();
        int separator = code.lastIndexOf("#");
        return code.substring(separator + 1);
    }
}

