/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakePreparedStatementV1
implements PreparedStatement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakePreparedStatementV1.class);
    private SnowflakeConnectionV1 connection;
    private String sql;
    private SnowflakeStatementV1 statement;
    private ResultSetMetaData resultMetadata;
    Map<String, Map<String, Object>> parameterBindings = new HashMap<String, Map<String, Object>>();
    Map<String, Map<String, Object>> batchParameterBindings = new HashMap<String, Map<String, Object>>();
    private int batchSize = 0;

    public SnowflakePreparedStatementV1(SnowflakeConnectionV1 conn, String sql) throws SQLException {
        logger.debug("SnowflakePreparedStatement(SnowflakeConnectionV1 conn,\nString sql) throws SQLException");
        this.connection = conn;
        this.sql = sql;
        this.statement = new SnowflakeStatementV1(conn);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        logger.debug("executeQuery() throws SQLException");
        ResultSet resultSet = this.statement.executeQueryInternal(this.sql, this.parameterBindings);
        this.resultMetadata = resultSet.getMetaData();
        return resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        logger.debug("executeUpdate() throws SQLException");
        return this.statement.executeUpdateInternal(this.sql, this.parameterBindings);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        logger.debug("setNull(int parameterIndex, int sqlType) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", null);
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(sqlType));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        logger.debug("setBoolean(int parameterIndex, boolean x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", String.valueOf(x));
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(16));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("setByte(int parameterIndex, byte x) Not supported yet.");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        logger.debug("setShort(int parameterIndex, short x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", String.valueOf(x));
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(5));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        logger.debug("setInt(int parameterIndex, int x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", String.valueOf(x));
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(4));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        logger.debug("setLong(int parameterIndex, long x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", String.valueOf(x));
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(-5));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        logger.debug("setFloat(int parameterIndex, float x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", String.valueOf(x));
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(6));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        logger.debug("setDouble(int parameterIndex, double x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", String.valueOf(x));
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(8));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        logger.debug("setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException");
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            HashMap<String, String> binding = new HashMap<String, String>();
            binding.put("value", String.valueOf(x));
            binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(3));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        logger.debug("setString(int parameterIndex, String x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", x);
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(12));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        logger.debug("setBytes(int parameterIndex, byte[] x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", new SFBinary(x).toHex());
        binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(-2));
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        logger.debug("setDate(int parameterIndex, Date x) throws SQLException");
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            HashMap<String, String> binding = new HashMap<String, String>();
            binding.put("value", String.valueOf(x.getTime() + (long)TimeZone.getDefault().getOffset(x.getTime())));
            binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(91));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        logger.debug("setTime(int parameterIndex, Time x) throws SQLException");
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            HashMap<String, String> binding = new HashMap<String, String>();
            long MS_IN_DAY = 86400000L;
            long msSinceEpoch = x.getTime();
            long msSinceMidnight = (msSinceEpoch % 86400000L + 86400000L) % 86400000L;
            long nanosSinceMidnight = msSinceMidnight * 1000L * 1000L;
            binding.put("value", String.valueOf(nanosSinceMidnight));
            binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(92));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        logger.debug("setTimestamp(int parameterIndex, Timestamp x) throws SQLException");
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("value", x == null ? null : String.valueOf(BigDecimal.valueOf(x.getTime() / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos()))));
        SnowflakeType sfType = SnowflakeUtil.javaTypeToSFType(93);
        if (sfType == SnowflakeType.TIMESTAMP) {
            sfType = this.connection.getSfSession().getTimestampMappedType();
        }
        binding.put("type", sfType.name());
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream(int parameterIndex, InputStream x, int length) Not supported yet.");
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setUnicodeStream(int parameterIndex, InputStream x, int length) Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream(int parameterIndex, InputStream x, int length) Not supported yet.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameterBindings.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        logger.debug("setObject(int parameterIndex, Object x, int targetSqlType)");
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else if (targetSqlType == 91) {
            this.setDate(parameterIndex, (Date)x);
        } else if (targetSqlType == 92) {
            this.setTime(parameterIndex, (Time)x);
        } else if (targetSqlType == 93) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            HashMap<String, String> binding = new HashMap<String, String>();
            binding.put("value", String.valueOf(x));
            binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(targetSqlType));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SnowflakeSQLException("0A000", ErrorCode.DATA_TYPE_NOT_SUPPORTED.getMessageCode(), "Object type: " + x.getClass());
        }
    }

    @Override
    public boolean execute() throws SQLException {
        logger.debug("execute: {}", this.sql);
        String trimmedSql = this.sql.trim();
        if (this.statement.isFileTransfer(trimmedSql)) {
            logger.debug("Executing file transfer locally: {}", this.sql);
            ResultSet resultSet = this.statement.executeQuery(this.sql);
            this.resultMetadata = resultSet.getMetaData();
            return true;
        }
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.statement.executeSetProperty(this.sql);
            return false;
        }
        SnowflakeResultSetV1 resultSet = (SnowflakeResultSetV1)this.statement.executeQueryInternal(this.sql, this.parameterBindings);
        if (this.connection.getSfSession().isExecuteReturnCountForDML() && (SFStatementType.isDDL(resultSet.getStatementTypeId()) || SFStatementType.isDML(resultSet.getStatementTypeId()))) {
            this.statement.setUpdateCount(ResultUtil.calculateUpdateCount(resultSet, resultSet.getStatementTypeId()));
            return false;
        }
        this.resultMetadata = resultSet.getMetaData();
        return true;
    }

    @Override
    public void addBatch() throws SQLException {
        logger.debug("addBatch() throws SQLException");
        for (Map.Entry<String, Map<String, Object>> binding : this.parameterBindings.entrySet()) {
            List<String> values;
            Map<String, Object> bindingValueAndType = this.batchParameterBindings.get(binding.getKey());
            if (bindingValueAndType == null) {
                bindingValueAndType = new HashMap<String, Object>();
                values = new ArrayList();
                bindingValueAndType.put("value", values);
                bindingValueAndType.put("type", (String)binding.getValue().get("type"));
                this.batchParameterBindings.put(binding.getKey(), bindingValueAndType);
            } else {
                String prevType = (String)bindingValueAndType.get("type");
                String newType = (String)binding.getValue().get("type");
                if (SnowflakeType.ANY.name().equalsIgnoreCase(prevType) && !SnowflakeType.ANY.name().equalsIgnoreCase(newType)) {
                    bindingValueAndType.put("type", newType);
                } else if (binding.getValue().get("value") != null && !prevType.equalsIgnoreCase(newType)) {
                    throw new SnowflakeSQLException("0A000", ErrorCode.ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED.getMessageCode(), SnowflakeType.getJavaType(SnowflakeType.fromString(prevType)).name(), SnowflakeType.getJavaType(SnowflakeType.fromString(newType)).name());
                }
                values = (List)bindingValueAndType.get("value");
            }
            values.add((String)binding.getValue().get("value"));
        }
        ++this.batchSize;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream(int parameterIndex, Reader reader, int length) Not supported yet.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("setRef(int parameterIndex, Ref x) Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("setBlob(int parameterIndex, Blob x) Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("setClob(int parameterIndex, Clob x) Not supported yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("setArray(int parameterIndex, Array x) Not supported yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.debug("getMetaData() throws SQLException");
        if (this.resultMetadata == null) {
            this.resultMetadata = this.statement.describeQueryInternal(this.sql, this.parameterBindings);
        }
        return this.resultMetadata;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        logger.debug("setDate(int parameterIndex, Date x, Calendar cal)");
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            HashMap<String, String> binding = new HashMap<String, String>();
            binding.put("value", String.valueOf(x.getTime() + (long)cal.getTimeZone().getOffset(x.getTime())));
            binding.put("type", SnowflakeUtil.javaTypeToSFTypeString(91));
            this.parameterBindings.put(String.valueOf(parameterIndex), binding);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        logger.debug("setTime(int parameterIndex, Time x, Calendar cal)");
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        logger.debug("setTimestamp(int parameterIndex, Timestamp x, Calendar cal)");
        HashMap<String, String> binding = new HashMap<String, String>();
        if (x != null) {
            long milliSecSinceEpoch = x.getTime();
            milliSecSinceEpoch += (long)cal.getTimeZone().getOffset(milliSecSinceEpoch);
            binding.put("value", String.valueOf(BigDecimal.valueOf(milliSecSinceEpoch / 1000L).scaleByPowerOfTen(9).add(BigDecimal.valueOf(x.getNanos()))));
        } else {
            binding.put("value", null);
        }
        SnowflakeType sfType = SnowflakeUtil.javaTypeToSFType(93);
        if (sfType == SnowflakeType.TIMESTAMP) {
            sfType = this.connection.getSfSession().getTimestampMappedType();
        }
        binding.put("type", sfType.name());
        this.parameterBindings.put(String.valueOf(parameterIndex), binding);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        logger.debug("setNull(int parameterIndex, int sqlType, String typeName)");
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("setURL(int parameterIndex, URL x) Not supported yet.");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("getParameterMetaData() Not supported yet.");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("setRowId(int parameterIndex, RowId x) Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("setNString(int parameterIndex, String value) Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("setNCharacterStream(int parameterIndex, Reader value, long length) Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("setNClob(int parameterIndex, NClob value) Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("setClob(int parameterIndex, Reader reader, long length) Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("setBlob(int parameterIndex, InputStream inputStream, long length) Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("setNClob(int parameterIndex, Reader reader, long length) Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("setSQLXML(int parameterIndex, SQLXML xmlObject) Not supported yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        logger.debug("setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength)");
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
        } else if (targetSqlType == 3 || targetSqlType == 2) {
            BigDecimal decimalObj = new BigDecimal(String.valueOf(x));
            decimalObj.setScale(scaleOrLength);
            this.setBigDecimal(parameterIndex, decimalObj);
        } else {
            this.setObject(parameterIndex, x, targetSqlType);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream(int parameterIndex, InputStream x, long length) Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream(int parameterIndex, InputStream x, long length) Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream(int parameterIndex, Reader reader, long length) Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream(int parameterIndex, InputStream x) Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream(int parameterIndex, InputStream x) Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream(int parameterIndex, Reader reader) Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("setNCharacterStream(int parameterIndex, Reader value) Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("setClob(int parameterIndex, Reader reader) Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("setBlob(int parameterIndex, InputStream inputStream) Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("setNClob(int parameterIndex, Reader reader) Not supported yet.");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        logger.debug("executeQuery(String sql) throws SQLException");
        return this.statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        logger.debug("executeUpdate(String sql) throws SQLException");
        return this.statement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        logger.debug("close() throws SQLException");
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        logger.debug("getMaxFieldSize() throws SQLException");
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("setMaxFieldSize(int max) Not supported yet.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        logger.debug("getMaxRows() throws SQLException");
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.debug("setMaxRows(int max) throws SQLException");
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("setEscapeProcessing(boolean enable) Not supported yet.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        logger.debug("getQueryTimeout() throws SQLException");
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.debug("setQueryTimeout(int seconds) throws SQLException");
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        logger.debug("cancel() throws SQLException");
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("getWarnings() throws SQLException");
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("clearWarnings() throws SQLException");
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("setCursorName(String name) Not supported yet.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        logger.debug("execute(String sql) throws SQLException");
        boolean hasResult = this.statement.execute(sql);
        if (hasResult) {
            ResultSet resultSet = this.statement.getResultSet();
            this.resultMetadata = resultSet.getMetaData();
            return true;
        }
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        logger.debug("public ResultSet getResultSet()");
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        logger.debug("getUpdateCount() throws SQLException");
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        logger.debug("getMoreResults() throws SQLException");
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.debug("setFetchDirection(int direction) throws SQLException");
        if (direction != 1000) {
            throw new UnsupportedOperationException("setFetchDirection(int direction) Not supported yet.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.debug("getFetchDirection() throws SQLException");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.debug("setFetchSize(int rows) throws SQLException");
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.debug("getFetchSize() throws SQLException");
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException("getResultSetConcurrency() Not supported yet.");
    }

    @Override
    public int getResultSetType() throws SQLException {
        logger.debug("getResultSetType() throws SQLException");
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("addBatch(String sql) Not supported yet.");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchParameterBindings.clear();
        this.batchSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        logger.debug("executeBatch() throws SQLException");
        int[] updateCounts = null;
        try {
            int updateCount = this.statement.executeUpdateInternal(this.sql, this.batchParameterBindings);
            if (updateCount == this.batchSize) {
                updateCounts = new int[updateCount];
                for (int idx = 0; idx < updateCount; ++idx) {
                    updateCounts[idx] = 1;
                }
            } else {
                updateCounts = new int[]{updateCount};
            }
        }
        finally {
            this.clearBatch();
        }
        return updateCounts;
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.debug("getConnection() throws SQLException");
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("getMoreResults(int current) Not supported yet.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("getGeneratedKeys() Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("executeUpdate(String sql, int autoGeneratedKeys) Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("executeUpdate(String sql, int[] columnIndexes) Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("executeUpdate(String sql, String[] columnNames) Not supported yet.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("execute(String sql, int autoGeneratedKeys) Not supported yet.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("execute(String sql, int[] columnIndexes) Not supported yet.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("execute(String sql, String[] columnNames) Not supported yet.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("getResultSetHoldability() Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug("isClosed() throws SQLException");
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("setPoolable(boolean poolable) Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("isPoolable() Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("closeOnCompletion() Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("isCloseOnCompletion() Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("unwrap(Class<T> iface)  Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("isWrapperFor(Class<?> iface)  Not supported yet.");
    }
}

