/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.NumberInput;

public class StdDateFormat
extends DateFormat {
    protected static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String DATE_FORMAT_STR_ISO8601_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String DATE_FORMAT_STR_PLAIN = "yyyy-MM-dd";
    protected static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String[] ALL_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd"};
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("GMT");
    protected static final DateFormat DATE_FORMAT_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final DateFormat DATE_FORMAT_ISO8601;
    protected static final DateFormat DATE_FORMAT_ISO8601_Z;
    protected static final DateFormat DATE_FORMAT_PLAIN;
    public static final StdDateFormat instance;
    protected transient TimeZone _timezone;
    protected transient DateFormat _formatRFC1123;
    protected transient DateFormat _formatISO8601;
    protected transient DateFormat _formatISO8601_z;
    protected transient DateFormat _formatPlain;

    public StdDateFormat() {
    }

    public StdDateFormat(TimeZone timeZone) {
        this._timezone = timeZone;
    }

    public static TimeZone getDefaultTimeZone() {
        return DEFAULT_TIMEZONE;
    }

    public StdDateFormat withTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        return new StdDateFormat(timeZone);
    }

    @Override
    public StdDateFormat clone() {
        return new StdDateFormat();
    }

    public static DateFormat getBlueprintISO8601Format() {
        return DATE_FORMAT_ISO8601;
    }

    public static DateFormat getISO8601Format(TimeZone timeZone) {
        return StdDateFormat._cloneFormat(DATE_FORMAT_ISO8601, timeZone);
    }

    public static DateFormat getBlueprintRFC1123Format() {
        return DATE_FORMAT_RFC1123;
    }

    public static DateFormat getRFC1123Format(TimeZone timeZone) {
        return StdDateFormat._cloneFormat(DATE_FORMAT_RFC1123, timeZone);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != this._timezone) {
            this._formatRFC1123 = null;
            this._formatISO8601 = null;
            this._formatISO8601_z = null;
            this._formatPlain = null;
            this._timezone = timeZone;
        }
    }

    @Override
    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition;
        Date date = this.parse(string = string.trim(), parsePosition = new ParsePosition(0));
        if (date != null) {
            return date;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : ALL_FORMATS) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\", \"");
            } else {
                stringBuilder.append('\"');
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append('\"');
        throw new ParseException(String.format("Can not parse date \"%s\": not compatible with any of standard forms (%s)", string, stringBuilder.toString()), parsePosition.getErrorIndex());
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        char c;
        if (this.looksLikeISO8601(string)) {
            return this.parseAsISO8601(string, parsePosition);
        }
        int n = string.length();
        while (--n >= 0 && ((c = string.charAt(n)) >= '0' && c <= '9' || n <= 0 && c == '-')) {
        }
        if (n < 0 && (string.charAt(0) == '-' || NumberInput.inLongRange(string, false))) {
            return new Date(Long.parseLong(string));
        }
        return this.parseAsRFC1123(string, parsePosition);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this._formatISO8601 == null) {
            this._formatISO8601 = this._cloneFormat(DATE_FORMAT_ISO8601);
        }
        return this._formatISO8601.format(date, stringBuffer, fieldPosition);
    }

    public String toString() {
        String string = "DateFormat " + this.getClass().getName();
        TimeZone timeZone = this._timezone;
        if (timeZone != null) {
            string = string + " (timezone: " + timeZone + ")";
        }
        return string;
    }

    protected boolean looksLikeISO8601(String string) {
        return string.length() >= 5 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(3)) && string.charAt(4) == '-';
    }

    protected Date parseAsISO8601(String string, ParsePosition parsePosition) {
        DateFormat dateFormat;
        int n = string.length();
        char c = string.charAt(n - 1);
        if (n <= 10 && Character.isDigit(c)) {
            dateFormat = this._formatPlain;
            if (dateFormat == null) {
                dateFormat = this._formatPlain = this._cloneFormat(DATE_FORMAT_PLAIN);
            }
        } else if (c == 'Z') {
            dateFormat = this._formatISO8601_z;
            if (dateFormat == null) {
                dateFormat = this._formatISO8601_z = this._cloneFormat(DATE_FORMAT_ISO8601_Z);
            }
            if (string.charAt(n - 4) == ':') {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.insert(n - 1, ".000");
                string = stringBuilder.toString();
            }
        } else if (StdDateFormat.hasTimeZone(string)) {
            StringBuilder stringBuilder;
            c = string.charAt(n - 3);
            if (c == ':') {
                stringBuilder = new StringBuilder(string);
                stringBuilder.delete(n - 3, n - 2);
                string = stringBuilder.toString();
            } else if (c == '+' || c == '-') {
                string = string + "00";
            }
            n = string.length();
            c = string.charAt(n - 9);
            if (Character.isDigit(c)) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.insert(n - 5, ".000");
                string = stringBuilder.toString();
            }
            dateFormat = this._formatISO8601;
            if (this._formatISO8601 == null) {
                dateFormat = this._formatISO8601 = this._cloneFormat(DATE_FORMAT_ISO8601);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = n - string.lastIndexOf(84) - 1;
            if (n2 <= 8) {
                stringBuilder.append(".000");
            }
            stringBuilder.append('Z');
            string = stringBuilder.toString();
            dateFormat = this._formatISO8601_z;
            if (dateFormat == null) {
                dateFormat = this._formatISO8601_z = this._cloneFormat(DATE_FORMAT_ISO8601_Z);
            }
        }
        return dateFormat.parse(string, parsePosition);
    }

    protected Date parseAsRFC1123(String string, ParsePosition parsePosition) {
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = this._cloneFormat(DATE_FORMAT_RFC1123);
        }
        return this._formatRFC1123.parse(string, parsePosition);
    }

    private static final boolean hasTimeZone(String string) {
        int n = string.length();
        if (n >= 6) {
            char c = string.charAt(n - 6);
            if (c == '+' || c == '-') {
                return true;
            }
            c = string.charAt(n - 5);
            if (c == '+' || c == '-') {
                return true;
            }
            c = string.charAt(n - 3);
            if (c == '+' || c == '-') {
                return true;
            }
        }
        return false;
    }

    private final DateFormat _cloneFormat(DateFormat dateFormat) {
        return StdDateFormat._cloneFormat(dateFormat, this._timezone);
    }

    private static final DateFormat _cloneFormat(DateFormat dateFormat, TimeZone timeZone) {
        dateFormat = (DateFormat)dateFormat.clone();
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    static {
        DATE_FORMAT_RFC1123.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601 = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601);
        DATE_FORMAT_ISO8601.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601_Z = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601_Z);
        DATE_FORMAT_ISO8601_Z.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_PLAIN = new SimpleDateFormat(DATE_FORMAT_STR_PLAIN);
        DATE_FORMAT_PLAIN.setTimeZone(DEFAULT_TIMEZONE);
        instance = new StdDateFormat();
    }
}

