/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyName;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.SettableBeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedField;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMember;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.Annotations;

public final class FieldProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedField _annotated;
    protected final transient Field _field;

    public FieldProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedField annotatedField) {
        super(beanPropertyDefinition, javaType, typeDeserializer, annotations);
        this._annotated = annotatedField;
        this._field = annotatedField.getAnnotated();
    }

    protected FieldProperty(FieldProperty fieldProperty, JsonDeserializer<?> jsonDeserializer) {
        super((SettableBeanProperty)fieldProperty, jsonDeserializer);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
    }

    protected FieldProperty(FieldProperty fieldProperty, PropertyName propertyName) {
        super((SettableBeanProperty)fieldProperty, propertyName);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
    }

    protected FieldProperty(FieldProperty fieldProperty, Field field) {
        super(fieldProperty);
        this._annotated = fieldProperty._annotated;
        if (field == null) {
            throw new IllegalArgumentException("No Field passed for property '" + fieldProperty.getName() + "' (class " + fieldProperty.getDeclaringClass().getName() + ")");
        }
        this._field = field;
    }

    @Override
    public FieldProperty withName(PropertyName propertyName) {
        return new FieldProperty(this, propertyName);
    }

    @Override
    public FieldProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return new FieldProperty(this, jsonDeserializer);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._annotated.getAnnotation(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        this.set(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        return this.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public final void set(Object object, Object object2) throws IOException {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
    }

    @Override
    public Object setAndReturn(Object object, Object object2) throws IOException {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
        return object;
    }

    Object readResolve() {
        return new FieldProperty(this, this._annotated.getAnnotated());
    }
}

