/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.snowflake.gscommon.core.S3FileEncryptionMaterial;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.regions.Region;
import net.snowflake.client.jdbc.internal.amazonaws.regions.RegionUtils;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3EncryptionClient;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.AmazonS3Exception;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoMode;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterials;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectListing;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PutObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.Download;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.TransferManager;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.Upload;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.ImmutablePair;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.Pair;

public class SnowflakeS3Client {
    private static final Logger logger = Logger.getLogger(SnowflakeS3Client.class.getName());
    private static final String localFileSep = System.getProperty("file.separator");
    private static final String AES = "AES";
    private static final String AMZ_MATDESC = "x-amz-matdesc";
    private static final String AMZ_KEY = "x-amz-key";
    private static final String AMZ_IV = "x-amz-iv";
    private static final String FILE_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String KEY_CIPHER = "AES/ECB/PKCS5Padding";
    private static final int BUFFER_SIZE = 0x200000;
    private static SecureRandom secRnd;
    private int encryptionKeySize = 0;
    private AmazonS3Client amazonClient = null;
    private S3FileEncryptionMaterial encMat = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SnowflakeS3Client(AWSCredentials awsCredentials, ClientConfiguration clientConfig, S3FileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        Region region;
        this.encMat = encMat;
        clientConfig.withSignerOverride("AWSS3V4SignerType");
        if (encMat != null) {
            byte[] decodedKey = Base64.decode(encMat.getQueryStageMasterKey());
            this.encryptionKeySize = decodedKey.length * 8;
            if (this.encryptionKeySize == 256) {
                SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, AES);
                EncryptionMaterials encryptionMaterials = new EncryptionMaterials(queryStageMasterKey);
                encryptionMaterials.addDescription("queryId", encMat.getQueryId());
                encryptionMaterials.addDescription("smkId", Long.toString(encMat.getSmkId()));
                CryptoConfiguration cryptoConfig = new CryptoConfiguration(CryptoMode.EncryptionOnly);
                this.amazonClient = new AmazonS3EncryptionClient(awsCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfig);
            } else {
                if (this.encryptionKeySize != 128) throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "unsupported key size", this.encryptionKeySize);
                this.amazonClient = new AmazonS3Client(awsCredentials, clientConfig);
            }
        } else {
            this.amazonClient = new AmazonS3Client(awsCredentials, clientConfig);
        }
        if (stageRegion == null || (region = RegionUtils.getRegion(stageRegion)) == null) return;
        this.amazonClient.setRegion(region);
    }

    private static synchronized SecureRandom getSecRnd() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (secRnd == null) {
            secRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
            byte[] bytes = new byte[10];
            secRnd.nextBytes(bytes);
        }
        return secRnd;
    }

    public boolean isEncrypting() {
        return this.encryptionKeySize > 0;
    }

    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public void shutdown() {
        this.amazonClient.shutdown();
    }

    public ObjectListing listObjects(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.amazonClient.listObjects(bucketName, prefix);
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.amazonClient.getObjectMetadata(bucketName, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(SnowflakeS3Client client, SFSession connection, String command, String localLocation, String destFileName, int parallelism, String bucketName, String stageFilePath, String stageRegion) throws SnowflakeSQLException {
        TransferManager tx = null;
        int retryCount = 0;
        do {
            try {
                File localFile = new File(localLocation + localFileSep + destFileName);
                logger.log(Level.FINE, "Creating executor service for transfermanager with {0} threads", parallelism);
                tx = new TransferManager(client.amazonClient, SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-downloader-", parallelism));
                Download myDownload = tx.download(bucketName, stageFilePath, localFile);
                ObjectMetadata meta = client.amazonClient.getObjectMetadata(bucketName, stageFilePath);
                Map<String, String> metaMap = meta.getUserMetadata();
                String key = metaMap.get(AMZ_KEY);
                String iv = metaMap.get(AMZ_IV);
                myDownload.waitForCompletion();
                if (client.isEncrypting() && client.getEncryptionKeySize() < 256) {
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "File metadata incomplete");
                    }
                    try {
                        client.decrypt(localFile, key, iv);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Error decrypting file", ex);
                        throw ex;
                    }
                }
                return;
            }
            catch (Exception ex) {
                client = SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "download", client.encMat, connection, command, parallelism, client, stageRegion);
            }
            finally {
                if (tx != null) {
                    tx.shutdownNow(false);
                }
            }
        } while (retryCount <= 25);
        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: download unsuccessful without exception!");
    }

    private void decrypt(File file, String keyBase64, String ivBase64) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, FileNotFoundException, IOException {
        byte[] keyBytes = Base64.decode(keyBase64);
        byte[] ivBytes = Base64.decode(ivBase64);
        byte[] qsmkBytes = Base64.decode(this.encMat.getQueryStageMasterKey());
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(qsmkBytes, 0, qsmkBytes.length, AES);
        keyCipher.init(2, queryStageMasterKey);
        byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, qsmkBytes.length, AES);
        Cipher fileCipher = Cipher.getInstance(FILE_CIPHER);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        byte[] buffer = new byte[0x200000];
        fileCipher.init(2, (Key)fileKey, iv);
        long totalBytesRead = 0L;
        try (InputStream is = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
             CipherInputStream cis = new CipherInputStream(is, fileCipher);
             OutputStream os = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE);){
            int bytesRead;
            while ((bytesRead = ((InputStream)cis).read(buffer)) > -1) {
                os.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
            }
        }
        var14_13 = null;
        try (FileChannel fc = new FileOutputStream(file, true).getChannel();){
            fc.truncate(totalBytesRead);
        }
        catch (Throwable throwable) {
            var14_13 = throwable;
            throw throwable;
        }
    }

    private CipherInputStream encrypt(ObjectMetadata meta, long originalContentLength, InputStream src) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, FileNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] decodedKey = Base64.decode(this.encMat.getQueryStageMasterKey());
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(FILE_CIPHER);
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        SnowflakeS3Client.getSecRnd().nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        SnowflakeS3Client.getSecRnd().nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, AES);
        fileCipher.init(1, (Key)fileKey, iv);
        CipherInputStream cis = new CipherInputStream(src, fileCipher);
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, AES);
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(this.encMat.getSmkId(), this.encMat.getQueryId(), keySize * 8);
        meta.addUserMetadata(AMZ_MATDESC, matDesc.toString());
        meta.addUserMetadata(AMZ_KEY, Base64.encodeAsString(encKeK));
        meta.addUserMetadata(AMZ_IV, Base64.encodeAsString(ivData));
        meta.setContentLength((originalContentLength + (long)blockSz) / (long)blockSz * (long)blockSz);
        return cis;
    }

    private static Pair<InputStream, Boolean> createUploadStream(SnowflakeS3Client client, File srcFile, boolean uploadFromStream, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, ObjectMetadata meta, long originalContentLength, List<FileInputStream> toClose) throws SnowflakeSQLException {
        InputStream result;
        logger.log(Level.FINE, "createUploadStream({0}, {1}, {2}, {3}, {4}, {5}, {6}) keySize={7}", new Object[]{client, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, meta, toClose, client.getEncryptionKeySize()});
        FileInputStream srcFileStream = null;
        if (client.isEncrypting() && client.getEncryptionKeySize() < 256) {
            try {
                InputStream inputStream2;
                if (uploadFromStream) {
                    inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    inputStream2 = srcFileStream;
                }
                InputStream uploadStream = inputStream2;
                toClose.add(srcFileStream);
                result = client.encrypt(meta, originalContentLength, uploadStream);
                uploadFromStream = true;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to encrypt input", ex);
                throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to encrypt input", ex.getMessage());
            }
        }
        try {
            InputStream inputStream3;
            if (uploadFromStream) {
                inputStream3 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
            } else {
                srcFileStream = new FileInputStream(srcFile);
                inputStream3 = srcFileStream;
            }
            result = inputStream3;
            toClose.add(srcFileStream);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, "Failed to open input file", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input file", ex.getMessage());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to open input stream", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input stream", ex.getMessage());
        }
        return new ImmutablePair<InputStream, Boolean>(result, uploadFromStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(SnowflakeS3Client client, SFSession connection, String command, int parallelism, int maxRetries, boolean uploadFromStream, String bucketName, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, ObjectMetadata meta, String stageRegion) throws SnowflakeSQLException {
        long originalContentLength = meta.getContentLength();
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        Pair<InputStream, Boolean> uploadStreamInfo = SnowflakeS3Client.createUploadStream(client, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, meta, originalContentLength, toClose);
        TransferManager tx = null;
        int retryCount = 0;
        do {
            try {
                Upload myUpload;
                logger.log(Level.FINE, "Creating executor service for transfermanager with {0} threads", parallelism);
                tx = new TransferManager(client.amazonClient, SnowflakeUtil.createDefaultExecutorService("s3-transfer-manager-uploader-", parallelism));
                if (uploadStreamInfo.getRight().booleanValue()) {
                    myUpload = tx.upload(bucketName, destFileName, uploadStreamInfo.getLeft(), meta);
                } else {
                    PutObjectRequest putRequest = new PutObjectRequest(bucketName, destFileName, srcFile);
                    putRequest.setMetadata(meta);
                    myUpload = tx.upload(putRequest);
                }
                myUpload.waitForCompletion();
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                client = SnowflakeS3Client.handleS3Exception(ex, ++retryCount, "upload", client.encMat, connection, command, parallelism, client, stageRegion);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = SnowflakeS3Client.createUploadStream(client, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, meta, originalContentLength, toClose);
            }
            finally {
                if (tx != null) {
                    tx.shutdownNow(false);
                }
            }
        } while (retryCount <= maxRetries);
        for (FileInputStream is : toClose) {
            IOUtils.closeQuietly(is);
        }
        throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: upload unsuccessful without exception!");
    }

    private static SnowflakeS3Client handleS3Exception(Exception ex, int retryCount, String operation, S3FileEncryptionMaterial encMat, SFSession connection, String command, int parallel, SnowflakeS3Client s3Client, String stageRegion) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support.";
            logger.log(Level.SEVERE, "JCE Unlimited Strength policy files missing: {0}. {1}.", new Object[]{ex.getMessage(), ex.getCause().getMessage()});
            String bootLib = System.getProperty("sun.boot.library.path");
            if (bootLib != null) {
                msg = msg + " The target directory on your system is: " + Paths.get(bootLib, "security").toString();
                logger.log(Level.SEVERE, msg);
            }
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, msg);
        }
        if (ex instanceof AmazonClientException) {
            if (retryCount > 25) {
                AmazonServiceException ex1;
                String extendedRequestId = "none";
                if (ex instanceof AmazonS3Exception) {
                    ex1 = (AmazonS3Exception)ex;
                    extendedRequestId = ((AmazonS3Exception)ex1).getExtendedRequestId();
                }
                if (ex instanceof AmazonServiceException) {
                    ex1 = (AmazonServiceException)ex;
                    throw new SnowflakeSQLException(ex1, "58000", (int)ErrorCode.S3_OPERATION_ERROR.getMessageCode(), operation, ex1.getErrorType().toString(), ex1.getErrorCode(), ex1.getMessage(), ex1.getRequestId(), extendedRequestId);
                }
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, ex.getMessage());
            }
            logger.log(Level.FINE, "Encountered exception ({0}) during " + operation + ", retry count: {1}", new Object[]{ex.getMessage(), retryCount});
            logger.log(Level.FINE, "Stack trace: ", ex);
            int backoffInMillis = 1000;
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, 4);
            }
            try {
                logger.log(Level.FINE, "Sleep for {0} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return SnowflakeFileTransferAgent.renewExpiredAWSToken(connection, command, parallel, s3Client, (AmazonClientException)ex, encMat, stageRegion);
        }
        if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
            if (retryCount > 25) {
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
            }
            logger.log(Level.FINE, "Encountered exception ({0}) during " + operation + ", retry count: {1}", new Object[]{ex.getMessage(), retryCount});
            return s3Client;
        }
        throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
    }
}

