/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.HashMap;
import java.util.Map;

public enum ErrorCode {
    INTERNAL_ERROR(200001, "XX000"),
    CONNECTION_ERROR(200002, "08001"),
    INTERRUPTED(200003, "57014"),
    COMPRESSION_TYPE_NOT_SUPPORTED(200004, "0A000"),
    QUERY_CANCELED(200005, "57014"),
    COMPRESSION_TYPE_NOT_KNOWN(200006, "0A000"),
    FAIL_LIST_FILES(200007, "22000"),
    FILE_NOT_FOUND(200008, "22000"),
    FILE_IS_DIRECTORY(200009, "22000"),
    DUPLICATE_CONNECTION_PROPERTY_SPECIFIED(200010, "22000"),
    MISSING_USERNAME(200011, "28000"),
    MISSING_PASSWORD(200012, "28000"),
    S3_OPERATION_ERROR(200013, "58000"),
    MAX_RESULT_LIMIT_EXCEEDED(200014, "54000"),
    NETWORK_ERROR(200015, "58030"),
    IO_ERROR(200016, "58030"),
    PATH_NOT_DIRECTORY(200017, "22000"),
    DATA_TYPE_NOT_SUPPORTED(200018, "0A000"),
    CLIENT_SIDE_SORTING_NOT_SUPPORTED(200019, "0A000"),
    AWS_CLIENT_ERROR(200020, "58000"),
    INVALID_SQL(200021, "03000"),
    BAD_RESPONSE(200022, "XX000"),
    ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED(200023, "0A000"),
    STATEMENT_CLOSED(200024, "0A000"),
    STATEMENT_ALREADY_RUNNING_QUERY(200025, "0A000"),
    MISSING_SERVER_URL(200026, "28000"),
    TOO_MANY_SESSION_PARAMETERS(200027, "0A000"),
    MISSING_CONNECTION_PROPERTY(200028, "28000"),
    INVALID_CONNECTION_URL(200029, "28000"),
    DUPLICATE_STATEMENT_PARAMETER_SPECIFIED(200030, "22000"),
    TOO_MANY_STATEMENT_PARAMETERS(200031, "0A000"),
    COLUMN_DOES_NOT_EXIST(200032, "22000"),
    INVALID_PARAMETER_TYPE(200033, "22023"),
    ROW_DOES_NOT_EXIST(200034, "22000"),
    FEATURE_UNSUPPORTED(200035, "0A000"),
    INVALID_STATE(200036, "0A000"),
    RESULTSET_ALREADY_CLOSED(200037, "0A000"),
    INVALID_VALUE_CONVERT(200038, "0A000");

    public static final String errorMessageResource = "com.snowflake.common_error_messages";
    private final Integer messageCode;
    private final String sqlState;
    private static Map<Integer, ErrorCode> errorCodeMap;

    private ErrorCode(Integer messageCode, String sqlState) {
        this.messageCode = messageCode;
        this.sqlState = sqlState;
    }

    public Integer getMessageCode() {
        return this.messageCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public String toString() {
        return "ErrorCode{messageCode=" + this.messageCode + ", sqlState=" + this.sqlState + '}';
    }

    public static ErrorCode getByErrorCode(String errorCode) {
        return errorCodeMap.get(errorCode);
    }

    static {
        errorCodeMap = new HashMap<Integer, ErrorCode>();
        for (ErrorCode errorCode : ErrorCode.values()) {
            errorCodeMap.put(errorCode.getMessageCode(), errorCode);
        }
    }
}

