/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.ByteArrayEntity;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;

public class StmtUtil {
    static final EventHandler eventHandler = EventUtil.getEventHandlerInstance();
    static final ObjectMapper mapper = new ObjectMapper();
    public static final String SF_PATH_QUERY_V1 = "/queries/v1/query-request";
    public static final String SF_PATH_ABORT_REQUEST_V1 = "/queries/v1/abort-request";
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    static final int SF_CANCELING_RETRY_TIMEOUT_IN_MILLIS = 600000;
    static final Logger logger = Logger.getLogger(StmtUtil.class.getName());

    public static StmtOutput execute(StmtInput stmtInput) throws SFException, SnowflakeSQLException {
        HttpRequestBase httpRequest = null;
        AssertUtil.assertTrue(stmtInput.serverUrl != null, "Missing server url for statement execution");
        AssertUtil.assertTrue(stmtInput.sql != null, "Missing sql for statement execution");
        AssertUtil.assertTrue(stmtInput.requestId != null, "Missing request id for statement execution");
        AssertUtil.assertTrue(stmtInput.sequenceId >= 0, "Negative sequence id for statement execution");
        AssertUtil.assertTrue(stmtInput.mediaType != null, "Missing media type for statement execution");
        AssertUtil.assertTrue(stmtInput.httpClient != null, "Missing http client for statement execution");
        try {
            String resultAsString = null;
            if (stmtInput.retry && stmtInput.prevGetResultURL != null) {
                logger.log(Level.FINER, "retrying statement execution with get result URL: {0}", stmtInput.prevGetResultURL);
            } else {
                URIBuilder uriBuilder = new URIBuilder(stmtInput.serverUrl);
                uriBuilder.setPath(SF_PATH_QUERY_V1);
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, stmtInput.requestId);
                httpRequest = new HttpPost(uriBuilder.build());
                HashMap<String, Object> sqlJsonBody = new HashMap<String, Object>();
                sqlJsonBody.put("sqlText", stmtInput.sql);
                sqlJsonBody.put("sequenceId", stmtInput.sequenceId);
                if (stmtInput.bindValues != null) {
                    sqlJsonBody.put("bindings", stmtInput.bindValues);
                }
                sqlJsonBody.put("describeOnly", stmtInput.describeOnly);
                if (stmtInput.parametersMap != null && !stmtInput.parametersMap.isEmpty()) {
                    sqlJsonBody.put("parameters", stmtInput.parametersMap);
                }
                String json = mapper.writeValueAsString(sqlJsonBody);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "JSON: {0}", json);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] bytes = json.getBytes("UTF-8");
                gzos.write(bytes);
                gzos.finish();
                ByteArrayEntity input = new ByteArrayEntity(baos.toByteArray());
                input.setContentType("application/json");
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(input);
                httpRequest.addHeader("content-encoding", "gzip");
                httpRequest.addHeader("accept", stmtInput.mediaType);
                httpRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + stmtInput.sessionToken + "\"");
                eventHandler.triggerStateTransition(BasicEvent.QueryState.SENDING_QUERY, String.format(BasicEvent.QueryState.SENDING_QUERY.getArgString(), stmtInput.requestId));
                resultAsString = HttpUtil.executeRequest(httpRequest, stmtInput.httpClient, stmtInput.networkTimeoutInMillis / 1000, stmtInput.injectSocketTimeout, stmtInput.canceling);
            }
            JsonNode pingPongResponseJson = null;
            boolean queryInProgress = true;
            boolean firstResponse = !stmtInput.retry;
            String previousGetResultPath = stmtInput.retry ? stmtInput.prevGetResultURL : null;
            int retries = 0;
            int MAX_RETRIES = 3;
            do {
                pingPongResponseJson = null;
                if (resultAsString != null) {
                    try {
                        pingPongResponseJson = mapper.readTree(resultAsString);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Bad result json: {0}, JSON parsing exception: {1}, http request: {2}", new Object[]{resultAsString, ex.getLocalizedMessage(), httpRequest});
                        logger.log(Level.SEVERE, "Exception stack trace", ex);
                    }
                }
                eventHandler.triggerStateTransition(BasicEvent.QueryState.WAITING_FOR_RESULT, "{requestId: " + stmtInput.requestId + "," + "pingNumber: " + retries + "}");
                if (pingPongResponseJson == null) {
                    if (retries >= 3) {
                        SFException sfe = IncidentUtil.generateIncidentWithException(stmtInput.sessionToken, stmtInput.serverUrl, stmtInput.requestId, null, ErrorCode.BAD_RESPONSE, resultAsString);
                        throw sfe;
                    }
                    logger.log(Level.INFO, "Will retry get result. Retry count: {0}", retries);
                    ++retries;
                } else {
                    retries = 0;
                }
                logger.log(Level.FINER, "Time: {0} Json response: {1}", new Object[]{System.currentTimeMillis(), resultAsString});
                if (pingPongResponseJson != null) {
                    SnowflakeUtil.checkErrorAndThrowException(pingPongResponseJson);
                }
                if (pingPongResponseJson != null && !"333333".equals(pingPongResponseJson.path("code").asText()) && !"333334".equals(pingPongResponseJson.path("code").asText())) {
                    queryInProgress = false;
                } else {
                    queryInProgress = true;
                    if (firstResponse && stmtInput.injectClientPause != 0) {
                        logger.log(Level.FINE, "inject client pause for {0} seconds", stmtInput.injectClientPause);
                        Thread.sleep(stmtInput.injectClientPause * 1000);
                    }
                    resultAsString = StmtUtil.getQueryResult(pingPongResponseJson, stmtInput.mediaType, previousGetResultPath, stmtInput);
                    if (pingPongResponseJson != null) {
                        stmtInput.prevGetResultURL = previousGetResultPath = pingPongResponseJson.path("data").path("getResultUrl").asText();
                    }
                }
                if (!firstResponse) continue;
                firstResponse = false;
            } while (queryInProgress);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Time: {0} Returning result", System.currentTimeMillis());
            }
            eventHandler.triggerStateTransition(BasicEvent.QueryState.PROCESSING_RESULT, String.format(BasicEvent.QueryState.PROCESSING_RESULT.getArgString(), stmtInput.requestId));
            StmtOutput stmtOutput = new StmtOutput(pingPongResponseJson);
            return stmtOutput;
        }
        catch (Exception ex) {
            if (!(ex instanceof SnowflakeSQLException)) {
                if (ex instanceof IOException) {
                    logger.log(Level.SEVERE, "IOException encountered", ex);
                    throw new SFException(ex, ErrorCode.NETWORK_ERROR, "Exception encountered when executing statement: " + ex.getLocalizedMessage());
                }
                logger.log(Level.SEVERE, "Exception encountered", ex);
                throw new SFException(ex, ErrorCode.INTERNAL_ERROR, ex.getLocalizedMessage());
            }
            throw (SnowflakeSQLException)ex;
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
                httpRequest = null;
            }
        }
    }

    protected static String getQueryResult(JsonNode inProgressResponse, String mediaType, String previousGetResultPath, StmtInput stmtInput) throws SFException, SnowflakeSQLException {
        HttpGet httpRequest = null;
        String getResultPath = null;
        if (inProgressResponse == null || inProgressResponse.path("data").path("getResultUrl").isMissingNode()) {
            if (previousGetResultPath == null) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "No query response or missing get result URL");
            }
            logger.log(Level.FINE, "No query response or missing get result URL, use previous get result URL: " + previousGetResultPath);
            getResultPath = previousGetResultPath;
        } else {
            getResultPath = inProgressResponse.path("data").path("getResultUrl").asText();
        }
        logger.log(Level.FINER, "get query result: {0}", getResultPath);
        try {
            URIBuilder uriBuilder = new URIBuilder(stmtInput.serverUrl);
            uriBuilder.setPath(getResultPath);
            uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
            httpRequest = new HttpGet(uriBuilder.build());
            httpRequest.addHeader("accept", mediaType);
            httpRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + stmtInput.sessionToken + "\"");
            String resultAsString = HttpUtil.executeRequest(httpRequest, stmtInput.httpClient, stmtInput.networkTimeoutInMillis / 1000, 0, stmtInput.canceling);
            return resultAsString;
        }
        catch (IOException | URISyntaxException ex) {
            logger.log(Level.SEVERE, "Exception encountered when getting result for " + httpRequest, ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, ex.getLocalizedMessage());
        }
    }

    public static void cancel(StmtInput stmtInput) throws SFException, SnowflakeSQLException {
        HttpPost httpRequest = null;
        AssertUtil.assertTrue(stmtInput.serverUrl != null, "Missing server url for statement execution");
        AssertUtil.assertTrue(stmtInput.sql != null, "Missing sql for statement execution");
        AssertUtil.assertTrue(stmtInput.mediaType != null, "Missing media type for statement execution");
        AssertUtil.assertTrue(stmtInput.requestId != null, "Missing request id for statement execution");
        AssertUtil.assertTrue(stmtInput.httpClient != null, "Missing http client for statement execution");
        AssertUtil.assertTrue(stmtInput.sessionToken != null, "Missing session token for statement execution");
        try {
            URIBuilder uriBuilder = new URIBuilder(stmtInput.serverUrl);
            logger.log(Level.FINER, "Aborting query: " + stmtInput.sql);
            uriBuilder.setPath(SF_PATH_ABORT_REQUEST_V1);
            uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
            httpRequest = new HttpPost(uriBuilder.build());
            HashMap<String, String> sqlJsonBody = new HashMap<String, String>();
            sqlJsonBody.put("sqlText", stmtInput.sql);
            sqlJsonBody.put(SF_QUERY_REQUEST_ID, stmtInput.requestId);
            String json = mapper.writeValueAsString(sqlJsonBody);
            logger.log(Level.FINER, "JSON for cancel request: {0}", json);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            httpRequest.setEntity(input);
            httpRequest.addHeader("accept", stmtInput.mediaType);
            httpRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + stmtInput.sessionToken + "\"");
            String jsonString = HttpUtil.executeRequest(httpRequest, stmtInput.httpClient, 600000, 0, null);
            logger.log(Level.FINER, "Json response: {0}", jsonString);
            JsonNode rootNode = null;
            rootNode = mapper.readTree(jsonString);
            SnowflakeUtil.checkErrorAndThrowException(rootNode);
        }
        catch (IOException | URISyntaxException ex) {
            logger.log(Level.SEVERE, "Exception encountered when canceling " + httpRequest, ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, ex.getLocalizedMessage());
        }
    }

    public static class StmtOutput {
        JsonNode result;

        public StmtOutput(JsonNode result) {
            this.result = result;
        }

        public JsonNode getResult() {
            return this.result;
        }
    }

    public static class StmtInput {
        String sql;
        String mediaType = "application/snowflake";
        Map<String, Map<String, Object>> bindValues;
        boolean describeOnly;
        String serverUrl;
        String requestId;
        int sequenceId = -1;
        Map<String, Object> parametersMap;
        String sessionToken;
        HttpClient httpClient;
        int networkTimeoutInMillis;
        int injectSocketTimeout;
        int injectClientPause;
        AtomicBoolean canceling = null;
        boolean retry;
        String prevGetResultURL = null;

        public StmtInput setSql(String sql) {
            this.sql = sql;
            return this;
        }

        public StmtInput setMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public StmtInput setParametersMap(Map<String, Object> parametersMap) {
            this.parametersMap = parametersMap;
            return this;
        }

        public StmtInput setBindValues(Map<String, Map<String, Object>> bindValues) {
            this.bindValues = bindValues;
            return this;
        }

        public StmtInput setDescribeOnly(boolean describeOnly) {
            this.describeOnly = describeOnly;
            return this;
        }

        public StmtInput setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public StmtInput setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public StmtInput setSequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public StmtInput parametersMap(Map<String, Object> parametersMap) {
            this.parametersMap = parametersMap;
            return this;
        }

        public StmtInput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public StmtInput setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public StmtInput setNetworkTimeoutInMillis(int networkTimeoutInMillis) {
            this.networkTimeoutInMillis = networkTimeoutInMillis;
            return this;
        }

        public StmtInput setInjectSocketTimeout(int injectSocketTimeout) {
            this.injectSocketTimeout = injectSocketTimeout;
            return this;
        }

        public StmtInput setInjectClientPause(int injectClientPause) {
            this.injectClientPause = injectClientPause;
            return this;
        }

        public StmtInput setCanceling(AtomicBoolean canceling) {
            this.canceling = canceling;
            return this;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }
    }
}

