/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.loader.BufferStage;
import net.snowflake.client.loader.LoadResultListener;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.LoadingError;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;

public class ProcessQueue
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ProcessQueue.class.getName());
    private final Thread _thread;
    private final StreamLoader _loader;
    private final boolean _preserveTemp = System.getProperty("snowflake.connector.preserveTemp") != null && System.getProperty("snowflake.connector.preserveTemp").equalsIgnoreCase("true");

    public ProcessQueue(StreamLoader loader) {
        LOGGER.log(Level.FINER, String.format("", new Object[0]));
        this._loader = loader;
        this._thread = new Thread(this);
        this._thread.setName("ProcessQueueThread");
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            BufferStage stage = null;
            Connection conn = this._loader.getProcessConnection();
            try {
                String loadStatement;
                stage = this._loader.takeProcess();
                if (stage.getRowCount() == 0) {
                    if (!stage.isTerminate()) continue;
                    return;
                }
                String remoteStage = "@" + this._loader.getRemoteStage() + "/" + stage.getRemoteLocation();
                StreamLoader streamLoader = this._loader;
                // MONITORENTER : streamLoader
                if (this._loader.isAborted()) {
                    LOGGER.log(Level.FINER, String.format("Aborted. RM: %s", remoteStage));
                    conn.createStatement().execute("RM " + remoteStage);
                    if (stage.isTerminate()) {
                        // MONITOREXIT : streamLoader
                        return;
                    }
                    // MONITOREXIT : streamLoader
                    continue;
                }
                int loaded = 0;
                int parsed = 0;
                int errorCount = 0;
                String lastErrorRow = "";
                LOGGER.log(Level.INFO, String.format("Creating Temporary Table: name=[%s]", stage.getId()));
                conn.createStatement().execute("CREATE TEMPORARY TABLE \"" + stage.getId() + "\" AS SELECT " + this._loader.getColumnsAsString() + " FROM " + this._loader.getFullTableName() + " WHERE FALSE");
                LOGGER.log(Level.INFO, String.format("Copying data in the stage to table: stage=[%s], name=[%s]", remoteStage, stage.getId()));
                ResultSet rs = conn.createStatement().executeQuery("COPY INTO \"" + stage.getId() + "\" FROM " + remoteStage + " on_error='continue'" + " file_format=(" + "field_optionally_enclosed_by='\"')");
                while (rs.next()) {
                    loaded += rs.getInt(4);
                    parsed += rs.getInt(3);
                }
                int errorRecordCount = parsed - loaded;
                LOGGER.log(Level.INFO, String.format("errorRecordCount=[%s], parsed=[%s], loaded=[%s]", errorRecordCount, parsed, loaded));
                LoadResultListener listener = this._loader.getListener();
                listener.addErrorRecordCount(errorRecordCount);
                if (loaded == stage.getRowCount()) {
                    LOGGER.log(Level.INFO, "COPY command successfully finished");
                    listener.addErrorCount(0);
                } else {
                    LOGGER.log(Level.INFO, "Found errors in COPY command");
                    if (listener.needErrors()) {
                        ResultSet errorsSet = conn.createStatement().executeQuery("COPY INTO \"" + stage.getId() + "\" FROM " + remoteStage + " validation_mode='return_all_errors'" + " file_format=(" + "field_optionally_enclosed_by='\"')");
                        Loader.DataError dataError = null;
                        while (errorsSet.next()) {
                            ++errorCount;
                            String rn = errorsSet.getString(LoadingError.ErrorProperty.ROW_NUMBER.name());
                            if (rn != null && !lastErrorRow.equals(rn)) {
                                lastErrorRow = rn;
                            }
                            LoadingError loadError = new LoadingError(errorsSet, stage, this._loader);
                            listener.addError(loadError);
                            if (dataError != null) continue;
                            dataError = loadError.getException();
                        }
                        LOGGER.log(Level.INFO, String.format("errorCount: %s", errorCount));
                        listener.addErrorCount(errorCount);
                        if (listener.throwOnError()) {
                            this._loader.abort(dataError);
                            LOGGER.log(Level.FINER, String.format("RM: %s", remoteStage));
                            conn.createStatement().execute("RM " + remoteStage);
                            if (stage.isTerminate()) {
                                // MONITOREXIT : streamLoader
                                return;
                            }
                            // MONITOREXIT : streamLoader
                            continue;
                        }
                    }
                }
                stage.setState(BufferStage.State.VALIDATED);
                StringBuilder setStatement = null;
                StringBuilder valueStatement = null;
                if (stage.getOp() != Operation.INSERT && stage.getOp() != Operation.DELETE) {
                    setStatement = new StringBuilder(" ");
                    valueStatement = new StringBuilder("(");
                    for (int c = 0; c < this._loader.getColumns().size(); ++c) {
                        String column = this._loader.getColumns().get(c);
                        if (c > 0) {
                            setStatement.append(", ");
                            valueStatement.append(" , ");
                        }
                        setStatement.append("T.\"").append(column).append("\"=").append("S.\"").append(column).append("\"");
                        valueStatement.append("S.\"").append(column).append("\"");
                    }
                    valueStatement.append(")");
                }
                switch (stage.getOp()) {
                    case INSERT: {
                        loadStatement = "INSERT INTO " + this._loader.getFullTableName() + "(" + this._loader.getColumnsAsString() + ")" + " SELECT * FROM \"" + stage.getId() + "\"";
                        break;
                    }
                    case DELETE: {
                        loadStatement = "DELETE FROM " + this._loader.getFullTableName() + " T USING \"" + stage.getId() + "\" AS S WHERE " + this.getOn(this._loader.getKeys(), "T", "S");
                        break;
                    }
                    case MODIFY: {
                        loadStatement = "MERGE INTO " + this._loader.getFullTableName() + " T USING \"" + stage.getId() + "\" AS S ON " + this.getOn(this._loader.getKeys(), "T", "S") + " WHEN MATCHED THEN UPDATE SET " + setStatement;
                        break;
                    }
                    case UPSERT: {
                        loadStatement = "MERGE INTO " + this._loader.getFullTableName() + " T USING \"" + stage.getId() + "\" AS S ON " + this.getOn(this._loader.getKeys(), "T", "S") + " WHEN MATCHED THEN UPDATE SET " + setStatement + " WHEN NOT MATCHED THEN INSERT(" + this._loader.getColumnsAsString() + ") VALUES" + valueStatement;
                        break;
                    }
                    default: {
                        loadStatement = "";
                    }
                }
                LOGGER.log(Level.FINER, String.format("Load Statement: %s", loadStatement));
                Statement s = conn.createStatement();
                s.execute(loadStatement);
                ResultSet prs = s.getResultSet();
                prs.next();
                stage.setState(BufferStage.State.PROCESSED);
                switch (stage.getOp()) {
                    case INSERT: {
                        this._loader.getListener().addProcessedRecordCount(stage.getOp(), stage.getRowCount());
                        this._loader.getListener().addOperationRecordCount(Operation.INSERT, prs.getInt(1));
                        break;
                    }
                    case DELETE: {
                        this._loader.getListener().addProcessedRecordCount(stage.getOp(), prs.getInt(1));
                        this._loader.getListener().addOperationRecordCount(Operation.DELETE, prs.getInt(1));
                        break;
                    }
                    case MODIFY: {
                        this._loader.getListener().addProcessedRecordCount(stage.getOp(), prs.getInt(1));
                        this._loader.getListener().addOperationRecordCount(Operation.MODIFY, prs.getInt(1));
                        break;
                    }
                    case UPSERT: {
                        this._loader.getListener().addProcessedRecordCount(stage.getOp(), stage.getRowCount());
                        this._loader.getListener().addOperationRecordCount(Operation.UPSERT, prs.getInt(1) + prs.getInt(2));
                        break;
                    }
                }
                if (!this._preserveTemp) {
                    conn.createStatement().execute("DROP TABLE \"" + stage.getId() + "\"");
                }
                conn.createStatement().execute("RM " + remoteStage);
                if (stage.isTerminate()) {
                    // MONITOREXIT : streamLoader
                    return;
                }
                // MONITOREXIT : streamLoader
                continue;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, "Interrupted", ex);
                return;
                catch (SQLException ex2) {
                    LOGGER.log(Level.SEVERE, ex2.getMessage(), ex2.getCause());
                    this._loader.abort(new Loader.ConnectionError(ex2.getMessage(), ex2.getCause()));
                    if (stage == null) return;
                    if (!stage.isTerminate()) continue;
                    return;
                }
                catch (Exception ex3) {
                    LOGGER.log(Level.SEVERE, null, ex3);
                    this._loader.abort(new Loader.ConnectionError(ex3.getMessage(), ex3.getCause()));
                    if (stage == null) return;
                    if (stage.isTerminate()) return;
                    continue;
                }
            }
            break;
        }
    }

    private String getOn(List<String> keys, String L, String R) {
        StringBuilder sb = keys.size() > 1 ? new StringBuilder(64) : new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            if (i > 0) {
                sb.append("AND ");
            }
            sb.append(L);
            sb.append(".\"");
            sb.append(keys.get(i));
            sb.append("\" = ");
            sb.append(R);
            sb.append(".\"");
            sb.append(keys.get(i));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public void join() {
        LOGGER.log(Level.FINER, String.format("", new Object[0]));
        try {
            this._thread.join(0L);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

