/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http;

import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.http.IdleConnectionReaper;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.SchemeRegistryFactory;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpParams;

class ConnectionManagerFactory {
    ConnectionManagerFactory() {
    }

    public static PoolingClientConnectionManager createPoolingClientConnManager(ClientConfiguration config, HttpParams httpClientParams) {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), config.getConnectionTTL(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        if (config.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(connectionManager);
        }
        return connectionManager;
    }
}

