/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.loader;

import com.snowflake.client.jdbc.SnowflakeConnectionV1;
import com.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import com.snowflake.client.loader.Loader;
import com.snowflake.client.loader.PutQueue;
import com.snowflake.client.loader.StreamLoader;
import java.io.File;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUploader
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(PutQueue.class.getName());
    private final Thread _thread;
    private final StreamLoader _loader;
    private final String _stage;
    private final File _file;

    public FileUploader(StreamLoader loader, String stage, File file) {
        LOGGER.log(Level.FINER, String.format("", new Object[0]));
        this._loader = loader;
        this._thread = new Thread(this);
        this._thread.setName("FileUploaderThread");
        this._stage = stage;
        this._file = file;
    }

    public synchronized void upload() {
        LOGGER.log(Level.FINER, String.format("", new Object[0]));
        this._loader.throttleUp();
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (int attempt = 0; attempt <= 6; ++attempt) {
                if (attempt == 6) {
                    this._loader.abort(new Loader.ConnectionError("File could not be uploaded to remote stage: " + this._file.getCanonicalPath()));
                    break;
                }
                if (attempt > 0) {
                    LOGGER.log(Level.INFO, String.format("Will retry PUT after %s seconds", Math.pow(2.0, attempt)));
                    Thread.sleep(1000 * (int)Math.pow(2.0, attempt));
                }
                if (this._loader._testMode) {
                    if (attempt < 2) {
                        ((SnowflakeConnectionV1)this._loader.getPutConnection()).setInjectFileUploadFailure(this._file.getName());
                    } else {
                        ((SnowflakeConnectionV1)this._loader.getPutConnection()).setInjectFileUploadFailure(null);
                    }
                }
                String remoteStage = "@" + this._loader.getRemoteStage() + "/" + this.remoteSeparator(this._stage);
                String putStatement = "PUT " + (attempt > 0 ? "/* retry:" + attempt + " */ " : "") + "file://" + this._file.getCanonicalPath() + " " + remoteStage + " parallel=4" + " auto_compress=false source_compression=gzip";
                Statement statement = this._loader.getPutConnection().createStatement();
                try {
                    LOGGER.log(Level.FINER, String.format("Put Statement: %s", putStatement));
                    statement.execute(putStatement);
                    ResultSet putResult = statement.getResultSet();
                    putResult.next();
                    String file = this.localSeparator(putResult.getString(SnowflakeFileTransferAgent.UploadColumns.source.name()));
                    String status = putResult.getString(SnowflakeFileTransferAgent.UploadColumns.status.name());
                    String message = putResult.getString(SnowflakeFileTransferAgent.UploadColumns.message.name());
                    if (status != null && status.equals(SnowflakeFileTransferAgent.ResultStatus.UPLOADED.name())) {
                        this._file.delete();
                        break;
                    }
                    Level logLevel = message.startsWith("Simulated upload failure") ? Level.INFO : Level.WARNING;
                    LOGGER.log(logLevel, String.format("Failed to upload a file: status=[%s], filename=[%s], message=[%s]", status, file, message));
                    continue;
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, String.format("Failed to PUT on attempt: attempt=[%s], Message=[%s]", attempt, t.getMessage()), t.getCause());
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "PUT exception", t);
            this._loader.abort(new Loader.ConnectionError(t.getMessage(), t.getCause()));
        }
        finally {
            this._loader.throttleDown();
        }
    }

    public void join() {
        LOGGER.log(Level.FINER, String.format("", new Object[0]));
        try {
            this._thread.join(0L);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private String remoteSeparator(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replace("\\", "/");
        }
        return fname;
    }

    private String localSeparator(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replace("/", "\\");
        }
        return fname;
    }
}

