/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.joda.time.convert;

import com.snowflake.client.jdbc.internal.joda.time.Chronology;
import com.snowflake.client.jdbc.internal.joda.time.DateTimeUtils;
import com.snowflake.client.jdbc.internal.joda.time.DateTimeZone;
import com.snowflake.client.jdbc.internal.joda.time.ReadableInstant;
import com.snowflake.client.jdbc.internal.joda.time.chrono.ISOChronology;
import com.snowflake.client.jdbc.internal.joda.time.convert.AbstractConverter;
import com.snowflake.client.jdbc.internal.joda.time.convert.InstantConverter;
import com.snowflake.client.jdbc.internal.joda.time.convert.PartialConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadableInstantConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final ReadableInstantConverter INSTANCE = new ReadableInstantConverter();

    protected ReadableInstantConverter() {
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        Chronology chronology = ((ReadableInstant)object).getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance(dateTimeZone);
        }
        DateTimeZone dateTimeZone2 = chronology.getZone();
        if (dateTimeZone2 != dateTimeZone && (chronology = chronology.withZone(dateTimeZone)) == null) {
            return ISOChronology.getInstance(dateTimeZone);
        }
        return chronology;
    }

    @Override
    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology == null) {
            chronology = ((ReadableInstant)object).getChronology();
            chronology = DateTimeUtils.getChronology(chronology);
        }
        return chronology;
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        return ((ReadableInstant)object).getMillis();
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInstant.class;
    }
}

