/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AnnotationIntrospector;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyMetadata;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyName;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.BeanUtil;

public class POJOPropertyBuilder
extends BeanPropertyDefinition
implements Comparable<POJOPropertyBuilder> {
    protected final boolean _forSerialization;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyName _name;
    protected final PropertyName _internalName;
    protected Linked<AnnotatedField> _fields;
    protected Linked<AnnotatedParameter> _ctorParameters;
    protected Linked<AnnotatedMethod> _getters;
    protected Linked<AnnotatedMethod> _setters;

    public POJOPropertyBuilder(PropertyName propertyName, AnnotationIntrospector annotationIntrospector, boolean bl) {
        this._internalName = propertyName;
        this._name = propertyName;
        this._annotationIntrospector = annotationIntrospector;
        this._forSerialization = bl;
    }

    @Deprecated
    public POJOPropertyBuilder(String string, AnnotationIntrospector annotationIntrospector, boolean bl) {
        this(new PropertyName(string), annotationIntrospector, bl);
    }

    public POJOPropertyBuilder(POJOPropertyBuilder pOJOPropertyBuilder, PropertyName propertyName) {
        this._internalName = pOJOPropertyBuilder._internalName;
        this._name = propertyName;
        this._annotationIntrospector = pOJOPropertyBuilder._annotationIntrospector;
        this._fields = pOJOPropertyBuilder._fields;
        this._ctorParameters = pOJOPropertyBuilder._ctorParameters;
        this._getters = pOJOPropertyBuilder._getters;
        this._setters = pOJOPropertyBuilder._setters;
        this._forSerialization = pOJOPropertyBuilder._forSerialization;
    }

    @Override
    @Deprecated
    public POJOPropertyBuilder withName(String string) {
        return this.withSimpleName(string);
    }

    @Override
    public POJOPropertyBuilder withName(PropertyName propertyName) {
        return new POJOPropertyBuilder(this, propertyName);
    }

    @Override
    public POJOPropertyBuilder withSimpleName(String string) {
        PropertyName propertyName = this._name.withSimpleName(string);
        return propertyName == this._name ? this : new POJOPropertyBuilder(this, propertyName);
    }

    @Override
    public int compareTo(POJOPropertyBuilder pOJOPropertyBuilder) {
        if (this._ctorParameters != null) {
            if (pOJOPropertyBuilder._ctorParameters == null) {
                return -1;
            }
        } else if (pOJOPropertyBuilder._ctorParameters != null) {
            return 1;
        }
        return this.getName().compareTo(pOJOPropertyBuilder.getName());
    }

    @Override
    public String getName() {
        return this._name == null ? null : this._name.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._name;
    }

    @Override
    public String getInternalName() {
        return this._internalName.getSimpleName();
    }

    @Override
    public PropertyName getWrapperName() {
        AnnotatedMember annotatedMember = this.getPrimaryMember();
        return annotatedMember == null || this._annotationIntrospector == null ? null : this._annotationIntrospector.findWrapperName(annotatedMember);
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return this._anyExplicitNames(this._fields) || this._anyExplicitNames(this._getters) || this._anyExplicitNames(this._setters) || this._anyExplicitNames(this._ctorParameters);
    }

    @Override
    public boolean hasGetter() {
        return this._getters != null;
    }

    @Override
    public boolean hasSetter() {
        return this._setters != null;
    }

    @Override
    public boolean hasField() {
        return this._fields != null;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._ctorParameters != null;
    }

    @Override
    public boolean couldSerialize() {
        return this._getters != null || this._fields != null;
    }

    @Override
    public AnnotatedMethod getGetter() {
        if (this._getters == null) {
            return null;
        }
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)this._getters.value;
        Linked linked = this._getters.next;
        while (linked != null) {
            block10: {
                boolean bl;
                AnnotatedMethod annotatedMethod2;
                block8: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block9: {
                        annotatedMethod2 = (AnnotatedMethod)linked.value;
                        clazz2 = annotatedMethod.getDeclaringClass();
                        if (clazz2 == (clazz = annotatedMethod2.getDeclaringClass())) break block8;
                        if (!clazz2.isAssignableFrom(clazz)) break block9;
                        annotatedMethod = annotatedMethod2;
                        break block10;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block10;
                }
                boolean bl2 = BeanUtil.okNameForIsGetter(annotatedMethod, annotatedMethod.getName()) != null;
                boolean bl3 = bl = BeanUtil.okNameForIsGetter(annotatedMethod2, annotatedMethod2.getName()) != null;
                if (bl2 != bl) {
                    if (bl2) {
                        annotatedMethod = annotatedMethod2;
                    }
                } else {
                    throw new IllegalArgumentException("Conflicting getter definitions for property \"" + this.getName() + "\": " + annotatedMethod.getFullName() + " vs " + annotatedMethod2.getFullName());
                }
            }
            linked = linked.next;
        }
        return annotatedMethod;
    }

    @Override
    public AnnotatedMethod getSetter() {
        if (this._setters == null) {
            return null;
        }
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)this._setters.value;
        Linked linked = this._setters.next;
        while (linked != null) {
            block7: {
                AnnotatedMethod annotatedMethod2;
                block5: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block6: {
                        annotatedMethod2 = (AnnotatedMethod)linked.value;
                        clazz2 = annotatedMethod.getDeclaringClass();
                        if (clazz2 == (clazz = annotatedMethod2.getDeclaringClass())) break block5;
                        if (!clazz2.isAssignableFrom(clazz)) break block6;
                        annotatedMethod = annotatedMethod2;
                        break block7;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block7;
                }
                throw new IllegalArgumentException("Conflicting setter definitions for property \"" + this.getName() + "\": " + annotatedMethod.getFullName() + " vs " + annotatedMethod2.getFullName());
            }
            linked = linked.next;
        }
        return annotatedMethod;
    }

    @Override
    public AnnotatedField getField() {
        if (this._fields == null) {
            return null;
        }
        AnnotatedField annotatedField = (AnnotatedField)this._fields.value;
        Linked linked = this._fields.next;
        while (linked != null) {
            block7: {
                AnnotatedField annotatedField2;
                block5: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block6: {
                        annotatedField2 = (AnnotatedField)linked.value;
                        clazz2 = annotatedField.getDeclaringClass();
                        if (clazz2 == (clazz = annotatedField2.getDeclaringClass())) break block5;
                        if (!clazz2.isAssignableFrom(clazz)) break block6;
                        annotatedField = annotatedField2;
                        break block7;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block7;
                }
                throw new IllegalArgumentException("Multiple fields representing property \"" + this.getName() + "\": " + annotatedField.getFullName() + " vs " + annotatedField2.getFullName());
            }
            linked = linked.next;
        }
        return annotatedField;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        if (this._ctorParameters == null) {
            return null;
        }
        Linked<AnnotatedParameter> linked = this._ctorParameters;
        do {
            if (!(((AnnotatedParameter)linked.value).getOwner() instanceof AnnotatedConstructor)) continue;
            return (AnnotatedParameter)linked.value;
        } while ((linked = linked.next) != null);
        return (AnnotatedParameter)this._ctorParameters.value;
    }

    @Override
    public AnnotatedMember getAccessor() {
        AnnotatedMember annotatedMember = this.getGetter();
        if (annotatedMember == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember getMutator() {
        AnnotatedMember annotatedMember = this.getConstructorParameter();
        if (annotatedMember == null && (annotatedMember = this.getSetter()) == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember getNonConstructorMutator() {
        AnnotatedMember annotatedMember = this.getSetter();
        if (annotatedMember == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        if (this._forSerialization) {
            return this.getAccessor();
        }
        return this.getMutator();
    }

    @Override
    public Class<?>[] findViews() {
        return this.fromMemberAnnotations(new WithMember<Class<?>[]>(){

            @Override
            public Class<?>[] withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findViews(annotatedMember);
            }
        });
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType() {
        return this.fromMemberAnnotations(new WithMember<AnnotationIntrospector.ReferenceProperty>(){

            @Override
            public AnnotationIntrospector.ReferenceProperty withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findReferenceType(annotatedMember);
            }
        });
    }

    @Override
    public boolean isTypeId() {
        Boolean bl = this.fromMemberAnnotations(new WithMember<Boolean>(){

            @Override
            public Boolean withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.isTypeId(annotatedMember);
            }
        });
        return bl != null && bl != false;
    }

    @Override
    public PropertyMetadata getMetadata() {
        Boolean bl = this._findRequired();
        String string = this._findDescription();
        if (bl == null) {
            return string == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : PropertyMetadata.STD_REQUIRED_OR_OPTIONAL.withDescription(string);
        }
        return PropertyMetadata.construct(bl, this._findDescription());
    }

    protected Boolean _findRequired() {
        Boolean bl = this.fromMemberAnnotations(new WithMember<Boolean>(){

            @Override
            public Boolean withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.hasRequiredMarker(annotatedMember);
            }
        });
        return bl;
    }

    protected String _findDescription() {
        return this.fromMemberAnnotations(new WithMember<String>(){

            @Override
            public String withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findPropertyDescription(annotatedMember);
            }
        });
    }

    @Override
    public ObjectIdInfo findObjectIdInfo() {
        return this.fromMemberAnnotations(new WithMember<ObjectIdInfo>(){

            @Override
            public ObjectIdInfo withMember(AnnotatedMember annotatedMember) {
                ObjectIdInfo objectIdInfo = POJOPropertyBuilder.this._annotationIntrospector.findObjectIdInfo(annotatedMember);
                if (objectIdInfo != null) {
                    objectIdInfo = POJOPropertyBuilder.this._annotationIntrospector.findObjectReferenceInfo(annotatedMember, objectIdInfo);
                }
                return objectIdInfo;
            }
        });
    }

    public void addField(AnnotatedField annotatedField, String string, boolean bl, boolean bl2) {
        this._fields = new Linked<AnnotatedField>(annotatedField, this._fields, string, bl, bl2);
    }

    public void addCtor(AnnotatedParameter annotatedParameter, String string, boolean bl, boolean bl2) {
        this._ctorParameters = new Linked<AnnotatedParameter>(annotatedParameter, this._ctorParameters, string, bl, bl2);
    }

    public void addGetter(AnnotatedMethod annotatedMethod, String string, boolean bl, boolean bl2) {
        this._getters = new Linked<AnnotatedMethod>(annotatedMethod, this._getters, string, bl, bl2);
    }

    public void addSetter(AnnotatedMethod annotatedMethod, String string, boolean bl, boolean bl2) {
        this._setters = new Linked<AnnotatedMethod>(annotatedMethod, this._setters, string, bl, bl2);
    }

    public void addAll(POJOPropertyBuilder pOJOPropertyBuilder) {
        this._fields = POJOPropertyBuilder.merge(this._fields, pOJOPropertyBuilder._fields);
        this._ctorParameters = POJOPropertyBuilder.merge(this._ctorParameters, pOJOPropertyBuilder._ctorParameters);
        this._getters = POJOPropertyBuilder.merge(this._getters, pOJOPropertyBuilder._getters);
        this._setters = POJOPropertyBuilder.merge(this._setters, pOJOPropertyBuilder._setters);
    }

    private static <T> Linked<T> merge(Linked<T> linked, Linked<T> linked2) {
        if (linked == null) {
            return linked2;
        }
        if (linked2 == null) {
            return linked;
        }
        return ((Linked)linked).append((Linked)linked2);
    }

    public void removeIgnored() {
        this._fields = this._removeIgnored(this._fields);
        this._getters = this._removeIgnored(this._getters);
        this._setters = this._removeIgnored(this._setters);
        this._ctorParameters = this._removeIgnored(this._ctorParameters);
    }

    @Deprecated
    public void removeNonVisible() {
        this.removeNonVisible(false);
    }

    public void removeNonVisible(boolean bl) {
        this._getters = this._removeNonVisible(this._getters);
        this._ctorParameters = this._removeNonVisible(this._ctorParameters);
        if (bl || this._getters == null) {
            this._fields = this._removeNonVisible(this._fields);
            this._setters = this._removeNonVisible(this._setters);
        }
    }

    public void trimByVisibility() {
        this._fields = this._trimByVisibility(this._fields);
        this._getters = this._trimByVisibility(this._getters);
        this._setters = this._trimByVisibility(this._setters);
        this._ctorParameters = this._trimByVisibility(this._ctorParameters);
    }

    public void mergeAnnotations(boolean bl) {
        if (bl) {
            if (this._getters != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._getters, this._fields, this._ctorParameters, this._setters);
                this._getters = this._getters.withValue(((AnnotatedMethod)this._getters.value).withAnnotations(annotationMap));
            } else if (this._fields != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._fields, this._ctorParameters, this._setters);
                this._fields = this._fields.withValue(((AnnotatedField)this._fields.value).withAnnotations(annotationMap));
            }
        } else if (this._ctorParameters != null) {
            AnnotationMap annotationMap = this._mergeAnnotations(0, this._ctorParameters, this._setters, this._fields, this._getters);
            this._ctorParameters = this._ctorParameters.withValue(((AnnotatedParameter)this._ctorParameters.value).withAnnotations(annotationMap));
        } else if (this._setters != null) {
            AnnotationMap annotationMap = this._mergeAnnotations(0, this._setters, this._fields, this._getters);
            this._setters = this._setters.withValue(((AnnotatedMethod)this._setters.value).withAnnotations(annotationMap));
        } else if (this._fields != null) {
            AnnotationMap annotationMap = this._mergeAnnotations(0, this._fields, this._getters);
            this._fields = this._fields.withValue(((AnnotatedField)this._fields.value).withAnnotations(annotationMap));
        }
    }

    private AnnotationMap _mergeAnnotations(int n, Linked<? extends AnnotatedMember> ... linkedArray) {
        AnnotationMap annotationMap = ((AnnotatedMember)linkedArray[n].value).getAllAnnotations();
        ++n;
        while (n < linkedArray.length) {
            if (linkedArray[n] != null) {
                return AnnotationMap.merge(annotationMap, this._mergeAnnotations(n, linkedArray));
            }
            ++n;
        }
        return annotationMap;
    }

    private <T> Linked<T> _removeIgnored(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.withoutIgnored();
    }

    private <T> Linked<T> _removeNonVisible(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.withoutNonVisible();
    }

    private <T> Linked<T> _trimByVisibility(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.trimByVisibility();
    }

    private <T> boolean _anyExplicitNames(Linked<T> linked) {
        while (linked != null) {
            if (linked.explicitName != null && linked.explicitName.length() > 0) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyVisible() {
        return this._anyVisible(this._fields) || this._anyVisible(this._getters) || this._anyVisible(this._setters) || this._anyVisible(this._ctorParameters);
    }

    private <T> boolean _anyVisible(Linked<T> linked) {
        while (linked != null) {
            if (linked.isVisible) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyIgnorals() {
        return this._anyIgnorals(this._fields) || this._anyIgnorals(this._getters) || this._anyIgnorals(this._setters) || this._anyIgnorals(this._ctorParameters);
    }

    private <T> boolean _anyIgnorals(Linked<T> linked) {
        while (linked != null) {
            if (linked.isMarkedIgnored) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public String findNewName() {
        Linked<? extends AnnotatedMember> linked = null;
        linked = this.findRenamed(this._fields, linked);
        linked = this.findRenamed(this._getters, linked);
        linked = this.findRenamed(this._setters, linked);
        return (linked = this.findRenamed(this._ctorParameters, linked)) == null ? null : linked.explicitName;
    }

    private Linked<? extends AnnotatedMember> findRenamed(Linked<? extends AnnotatedMember> linked, Linked<? extends AnnotatedMember> linked2) {
        while (linked != null) {
            String string = linked.explicitName;
            if (string != null && !string.equals(this._name)) {
                if (linked2 == null) {
                    linked2 = linked;
                } else if (!string.equals(linked2.explicitName)) {
                    throw new IllegalStateException("Conflicting property name definitions: '" + linked2.explicitName + "' (for " + linked2.value + ") vs '" + linked.explicitName + "' (for " + linked.value + ")");
                }
            }
            linked = linked.next;
        }
        return linked2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Property '").append(this._name).append("'; ctors: ").append(this._ctorParameters).append(", field(s): ").append(this._fields).append(", getter(s): ").append(this._getters).append(", setter(s): ").append(this._setters);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected <T> T fromMemberAnnotations(WithMember<T> withMember) {
        T t = null;
        if (this._annotationIntrospector != null) {
            if (this._forSerialization) {
                if (this._getters != null) {
                    t = withMember.withMember((AnnotatedMember)this._getters.value);
                }
            } else {
                if (this._ctorParameters != null) {
                    t = withMember.withMember((AnnotatedMember)this._ctorParameters.value);
                }
                if (t == null && this._setters != null) {
                    t = withMember.withMember((AnnotatedMember)this._setters.value);
                }
            }
            if (t == null && this._fields != null) {
                t = withMember.withMember((AnnotatedMember)this._fields.value);
            }
        }
        return t;
    }

    private static final class Linked<T> {
        public final T value;
        public final Linked<T> next;
        public final String explicitName;
        public final boolean isVisible;
        public final boolean isMarkedIgnored;

        public Linked(T t, Linked<T> linked, String string, boolean bl, boolean bl2) {
            this.value = t;
            this.next = linked;
            this.explicitName = string == null ? null : (string.length() == 0 ? null : string);
            this.isVisible = bl;
            this.isMarkedIgnored = bl2;
        }

        public Linked<T> withValue(T t) {
            if (t == this.value) {
                return this;
            }
            return new Linked<T>(t, this.next, this.explicitName, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withNext(Linked<T> linked) {
            if (linked == this.next) {
                return this;
            }
            return new Linked<T>(this.value, linked, this.explicitName, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withoutIgnored() {
            Linked<T> linked;
            if (this.isMarkedIgnored) {
                return this.next == null ? null : this.next.withoutIgnored();
            }
            if (this.next != null && (linked = this.next.withoutIgnored()) != this.next) {
                return this.withNext(linked);
            }
            return this;
        }

        public Linked<T> withoutNonVisible() {
            Linked<T> linked = this.next == null ? null : this.next.withoutNonVisible();
            return this.isVisible ? this.withNext(linked) : linked;
        }

        private Linked<T> append(Linked<T> linked) {
            if (this.next == null) {
                return this.withNext(linked);
            }
            return this.withNext(super.append(linked));
        }

        public Linked<T> trimByVisibility() {
            if (this.next == null) {
                return this;
            }
            Linked<T> linked = this.next.trimByVisibility();
            if (this.explicitName != null) {
                if (linked.explicitName == null) {
                    return this.withNext(null);
                }
                return this.withNext(linked);
            }
            if (linked.explicitName != null) {
                return linked;
            }
            if (this.isVisible == linked.isVisible) {
                return this.withNext(linked);
            }
            return this.isVisible ? this.withNext(null) : linked;
        }

        public String toString() {
            String string = this.value.toString() + "[visible=" + this.isVisible + "]";
            if (this.next != null) {
                string = string + ", " + this.next.toString();
            }
            return string;
        }
    }

    private static interface WithMember<T> {
        public T withMember(AnnotatedMember var1);
    }
}

