/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Collection;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _collectionType;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, valueInstantiator, null, jsonDeserializer);
    }

    protected StringCollectionDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2) {
        super(javaType);
        this._collectionType = javaType;
        this._valueDeserializer = jsonDeserializer2;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2) {
        if (this._valueDeserializer == jsonDeserializer2 && this._delegateDeserializer == jsonDeserializer) {
            return this;
        }
        return new StringCollectionDeserializer(this._collectionType, this._valueInstantiator, jsonDeserializer, jsonDeserializer2);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        JsonDeserializer<Object> jsonDeserializer2 = null;
        if (this._valueInstantiator != null && (jsonDeserializer = this._valueInstantiator.getDelegateCreator()) != null) {
            JavaType javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            jsonDeserializer2 = this.findDeserializer(deserializationContext, javaType, beanProperty);
        }
        if ((jsonDeserializer = this._valueDeserializer) == null) {
            if ((jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer)) == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(this._collectionType.getContentType(), beanProperty);
            }
        } else {
            jsonDeserializer = deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty);
        }
        if (this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        return this.withResolved(jsonDeserializer2, jsonDeserializer);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        return jsonDeserializer;
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        Collection collection = (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
        return this.deserialize(jsonParser, deserializationContext, collection);
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException, JsonProcessingException {
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jsonParser, deserializationContext, collection, this._valueDeserializer);
        }
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            collection.add(jsonToken == JsonToken.VALUE_NULL ? null : this._parseString(jsonParser, deserializationContext));
        }
        return collection;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection, JsonDeserializer<String> jsonDeserializer) throws IOException, JsonProcessingException {
        JsonToken jsonToken;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            String string = jsonToken == JsonToken.VALUE_NULL ? null : jsonDeserializer.deserialize(jsonParser, deserializationContext);
            collection.add(string);
        }
        return collection;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final Collection<String> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException, JsonProcessingException {
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._collectionType.getRawClass());
        }
        JsonDeserializer<String> jsonDeserializer = this._valueDeserializer;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        String string = jsonToken == JsonToken.VALUE_NULL ? null : (jsonDeserializer == null ? this._parseString(jsonParser, deserializationContext) : jsonDeserializer.deserialize(jsonParser, deserializationContext));
        collection.add(string);
        return collection;
    }
}

