/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.http.impl.cookie;

import com.snowflake.client.jdbc.internal.apache.http.HeaderElement;
import com.snowflake.client.jdbc.internal.apache.http.NameValuePair;
import com.snowflake.client.jdbc.internal.apache.http.ParseException;
import com.snowflake.client.jdbc.internal.apache.http.annotation.Immutable;
import com.snowflake.client.jdbc.internal.apache.http.message.BasicHeaderElement;
import com.snowflake.client.jdbc.internal.apache.http.message.BasicNameValuePair;
import com.snowflake.client.jdbc.internal.apache.http.message.ParserCursor;
import com.snowflake.client.jdbc.internal.apache.http.protocol.HTTP;
import com.snowflake.client.jdbc.internal.apache.http.util.Args;
import com.snowflake.client.jdbc.internal.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();

    public HeaderElement parseHeader(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseNameValuePair(buffer, cursor);
            params.add(param);
        }
        return new BasicHeaderElement(nvp.getName(), nvp.getValue(), params.toArray(new NameValuePair[params.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        char ch;
        int pos;
        boolean terminated = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        String name = null;
        for (pos = cursor.getPos(); pos < indexTo && (ch = buffer.charAt(pos)) != '='; ++pos) {
            if (ch != ';') continue;
            terminated = true;
            break;
        }
        if (pos == indexTo) {
            terminated = true;
            name = buffer.substringTrimmed(indexFrom, indexTo);
        } else {
            name = buffer.substringTrimmed(indexFrom, pos);
            ++pos;
        }
        if (terminated) {
            cursor.updatePos(pos);
            return new BasicNameValuePair(name, null);
        }
        String value = null;
        int i1 = pos;
        while (pos < indexTo) {
            char ch2 = buffer.charAt(pos);
            if (ch2 == ';') {
                terminated = true;
                break;
            }
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && HTTP.isWhitespace(buffer.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        value = buffer.substring(i1, i2);
        if (terminated) {
            ++pos;
        }
        cursor.updatePos(pos);
        return new BasicNameValuePair(name, value);
    }
}

