/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.regions;

import com.snowflake.client.jdbc.internal.amazonaws.regions.Region;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RegionMetadata {
    private final List<Region> regions;

    public RegionMetadata(List<Region> regions) {
        if (regions == null) {
            throw new IllegalArgumentException("regions cannot be null");
        }
        this.regions = Collections.unmodifiableList(new ArrayList<Region>(regions));
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public Region getRegion(String name) {
        for (Region region : this.regions) {
            if (!region.getName().equals(name)) continue;
            return region;
        }
        return null;
    }

    public List<Region> getRegionsForService(String service) {
        LinkedList<Region> results = new LinkedList<Region>();
        for (Region region : this.regions) {
            if (!region.isServiceSupported(service)) continue;
            results.add(region);
        }
        return results;
    }

    public Region getRegionByEndpoint(String endpoint) {
        String host = RegionMetadata.getHost(endpoint);
        for (Region region : this.regions) {
            for (String serviceEndpoint : region.getServiceEndpoints().values()) {
                if (!host.equals(RegionMetadata.getHost(serviceEndpoint))) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + endpoint);
    }

    private static String getHost(String endpoint) {
        String host = URI.create(endpoint).getHost();
        if (host == null) {
            host = URI.create("http://" + endpoint).getHost();
        }
        return host;
    }

    public String toString() {
        return this.regions.toString();
    }
}

