/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.http.conn.ssl;

import com.snowflake.client.jdbc.internal.amazonaws.http.conn.ssl.TLSProtocol;
import com.snowflake.client.jdbc.internal.amazonaws.internal.SdkSSLSocket;
import com.snowflake.client.jdbc.internal.amazonaws.internal.SdkSocket;
import com.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import com.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import com.snowflake.client.jdbc.internal.apache.http.annotation.ThreadSafe;
import com.snowflake.client.jdbc.internal.apache.http.conn.ConnectTimeoutException;
import com.snowflake.client.jdbc.internal.apache.http.conn.ssl.SSLSocketFactory;
import com.snowflake.client.jdbc.internal.apache.http.conn.ssl.X509HostnameVerifier;
import com.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;

@ThreadSafe
public class SdkTLSSocketFactory
extends SSLSocketFactory {
    private static final Log log = LogFactory.getLog(SdkTLSSocketFactory.class);
    private final SSLContext sslContext;

    public SdkTLSSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        if (sslContext == null) {
            throw new NullPointerException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
        this.sslContext = sslContext;
    }

    @Override
    protected final void prepareSocket(SSLSocket socket) {
        Object[] supported = socket.getSupportedProtocols();
        Object[] enabled = socket.getEnabledProtocols();
        if (log.isDebugEnabled()) {
            log.debug("socket.getSupportedProtocols(): " + Arrays.toString(supported) + ", socket.getEnabledProtocols(): " + Arrays.toString(enabled));
        }
        ArrayList<Object> target = new ArrayList<Object>();
        if (supported != null) {
            TLSProtocol[] values = TLSProtocol.values();
            for (int i = 0; i < values.length; ++i) {
                String pname = values[i].getProtocolName();
                if (!this.existsIn(pname, (String[])supported)) continue;
                target.add(pname);
            }
        }
        if (enabled != null) {
            for (Object pname : enabled) {
                if (target.contains(pname)) continue;
                target.add(pname);
            }
        }
        if (target.size() > 0) {
            Object[] enabling = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols((String[])enabling);
            if (log.isDebugEnabled()) {
                log.debug("TLS protocol enabled for SSL handshake: " + Arrays.toString(enabling));
            }
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (log.isDebugEnabled()) {
            log.debug("connecting to " + remoteAddress.getAddress() + ":" + remoteAddress.getPort());
        }
        try {
            this.verifyMasterSecret(super.connectSocket(socket, remoteAddress, localAddress, params));
        }
        catch (SSLException sslEx) {
            if (log.isDebugEnabled()) {
                log.debug("connection failed due to SSL error, clearing TLS session cache", sslEx);
            }
            this.clearSessionCache(this.sslContext.getClientSessionContext(), remoteAddress);
            throw sslEx;
        }
        if (socket instanceof SSLSocket) {
            return new SdkSSLSocket((SSLSocket)socket);
        }
        return new SdkSocket(socket);
    }

    private void clearSessionCache(SSLSessionContext sessionContext, InetSocketAddress remoteAddress) {
        String hostName = remoteAddress.getHostName();
        int port = remoteAddress.getPort();
        Enumeration<byte[]> ids = sessionContext.getIds();
        if (ids == null) {
            return;
        }
        while (ids.hasMoreElements()) {
            byte[] id = ids.nextElement();
            SSLSession session = sessionContext.getSession(id);
            if (session == null || session.getPeerHost() == null || !session.getPeerHost().equalsIgnoreCase(hostName) || session.getPeerPort() != port) continue;
            session.invalidate();
            if (!log.isDebugEnabled()) continue;
            log.debug("Invalidated session " + session);
        }
    }

    private void verifyMasterSecret(Socket sock) {
        String className;
        SSLSocket ssl;
        SSLSession session;
        if (sock instanceof SSLSocket && (session = (ssl = (SSLSocket)sock).getSession()) != null && "sun.security.ssl.SSLSessionImpl".equals(className = session.getClass().getName())) {
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getDeclaredMethod("getMasterSecret", new Class[0]);
                method.setAccessible(true);
                Object masterSecret = method.invoke((Object)session, new Object[0]);
                if (masterSecret == null) {
                    session.invalidate();
                    if (log.isDebugEnabled()) {
                        log.debug("Invalidated session " + session);
                    }
                    throw this.log(new SecurityException("Invalid SSL master secret"));
                }
            }
            catch (ClassNotFoundException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (NoSuchMethodException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (IllegalAccessException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (InvocationTargetException e) {
                this.failedToVerifyMasterSecret(e.getCause());
            }
        }
    }

    private void failedToVerifyMasterSecret(Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug("Failed to verify the SSL master secret", t);
        }
    }

    private <T extends Throwable> T log(T t) {
        if (log.isDebugEnabled()) {
            log.debug("", t);
        }
        return t;
    }
}

