/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContainerSerializer;
import java.io.IOException;

public abstract class ArraySerializerBase<T>
extends ContainerSerializer<T> {
    protected final BeanProperty _property;

    protected ArraySerializerBase(Class<T> clazz) {
        super(clazz);
        this._property = null;
    }

    protected ArraySerializerBase(Class<T> clazz, BeanProperty beanProperty) {
        super(clazz);
        this._property = beanProperty;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> arraySerializerBase) {
        super(arraySerializerBase._handledType, false);
        this._property = arraySerializerBase._property;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> arraySerializerBase, BeanProperty beanProperty) {
        super(arraySerializerBase._handledType, false);
        this._property = beanProperty;
    }

    @Override
    public final void serialize(T t, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(t)) {
            this.serializeContents(t, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray();
        this.serializeContents(t, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public final void serializeWithType(T t, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForArray(t, jsonGenerator);
        this.serializeContents(t, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForArray(t, jsonGenerator);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;
}

