/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.HashSet;

public class BeanAsArrayBuilderDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;
    protected final AnnotatedMethod _buildMethod;

    public BeanAsArrayBuilderDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty[] settableBeanPropertyArray, AnnotatedMethod annotatedMethod) {
        super(beanDeserializerBase);
        this._delegate = beanDeserializerBase;
        this._orderedProperties = settableBeanPropertyArray;
        this._buildMethod = annotatedMethod;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return this._delegate.unwrappingDeserializer(nameTransformer);
    }

    @Override
    public BeanAsArrayBuilderDeserializer withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withObjectIdReader(objectIdReader), this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanAsArrayBuilderDeserializer withIgnorableProperties(HashSet<String> hashSet) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withIgnorableProperties(hashSet), this._orderedProperties, this._buildMethod);
    }

    @Override
    protected BeanAsArrayBuilderDeserializer asArrayDeserializer() {
        return this;
    }

    protected final Object finishBuild(DeserializationContext deserializationContext, Object object) throws IOException {
        try {
            return this._buildMethod.getMember().invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY) {
            return this.finishBuild(deserializationContext, this._deserializeFromNonArray(jsonParser, deserializationContext));
        }
        if (!this._vanillaProcessing) {
            return this.finishBuild(deserializationContext, this._deserializeNonVanilla(jsonParser, deserializationContext));
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return this.finishBuild(deserializationContext, object);
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n;
        }
        if (!this._ignoreAllUnknown) {
            throw deserializationContext.mappingException("Unexpected JSON values; expected at most " + n2 + " properties (in JSON Array)");
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return this.finishBuild(deserializationContext, object);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return this.finishBuild(deserializationContext, object);
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n;
        }
        if (!this._ignoreAllUnknown) {
            throw deserializationContext.mappingException("Unexpected JSON values; expected at most " + n2 + " properties (in JSON Array)");
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return this.finishBuild(deserializationContext, object);
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        return this._deserializeFromNonArray(jsonParser, deserializationContext);
    }

    protected Object _deserializeNonVanilla(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._nonStandardCreation) {
            return this._deserializeWithCreator(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            ++n;
            if (settableBeanProperty != null && (clazz == null || settableBeanProperty.visibleInView(clazz))) {
                try {
                    settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
                continue;
            }
            jsonParser.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            throw deserializationContext.mappingException("Unexpected JSON values; expected at most " + n2 + " properties (in JSON Array)");
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return object;
    }

    protected Object _deserializeWithCreator(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jsonParser, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        throw JsonMappingException.from(jsonParser, "No suitable constructor found for type " + this._beanType + ": can not instantiate from JSON object (need to add/enable type information?)");
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = settableBeanPropertyArray.length;
        int n2 = 0;
        Object object = null;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            block17: {
                SettableBeanProperty settableBeanProperty;
                SettableBeanProperty settableBeanProperty2 = settableBeanProperty = n2 < n ? settableBeanPropertyArray[n2] : null;
                if (settableBeanProperty == null) {
                    jsonParser.skipChildren();
                } else if (object != null) {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                    }
                } else {
                    String string = settableBeanProperty.getName();
                    SettableBeanProperty settableBeanProperty3 = propertyBasedCreator.findCreatorProperty(string);
                    if (settableBeanProperty3 != null) {
                        Object object2 = settableBeanProperty3.deserialize(jsonParser, deserializationContext);
                        if (propertyValueBuffer.assignParameter(settableBeanProperty3.getCreatorIndex(), object2)) {
                            try {
                                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), string, deserializationContext);
                                break block17;
                            }
                            if (object.getClass() != this._beanType.getRawClass()) {
                                throw deserializationContext.mappingException("Can not support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type " + this._beanType.getRawClass().getName() + ", actual type " + object.getClass().getName());
                            }
                        }
                    } else if (!propertyValueBuffer.readIdProperty(string)) {
                        propertyValueBuffer.bufferProperty(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext));
                    }
                }
            }
            ++n2;
        }
        if (object == null) {
            try {
                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
            }
            catch (Exception exception) {
                this.wrapInstantiationProblem(exception, deserializationContext);
                return null;
            }
        }
        return object;
    }

    protected Object _deserializeFromNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        throw deserializationContext.mappingException("Can not deserialize a POJO (of type " + this._beanType.getRawClass().getName() + ") from non-Array representation (token: " + (Object)((Object)jsonParser.getCurrentToken()) + "): type/property designed to be serialized as JSON Array");
    }
}

