/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.parser;

import com.snowflake.client.jdbc.internal.apache.tika.config.TikaConfig;
import com.snowflake.client.jdbc.internal.apache.tika.detect.DefaultDetector;
import com.snowflake.client.jdbc.internal.apache.tika.detect.Detector;
import com.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import com.snowflake.client.jdbc.internal.apache.tika.io.TemporaryResources;
import com.snowflake.client.jdbc.internal.apache.tika.io.TikaInputStream;
import com.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import com.snowflake.client.jdbc.internal.apache.tika.mime.MediaType;
import com.snowflake.client.jdbc.internal.apache.tika.mime.MediaTypeRegistry;
import com.snowflake.client.jdbc.internal.apache.tika.parser.CompositeParser;
import com.snowflake.client.jdbc.internal.apache.tika.parser.ParseContext;
import com.snowflake.client.jdbc.internal.apache.tika.parser.Parser;
import com.snowflake.client.jdbc.internal.apache.tika.sax.SecureContentHandler;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AutoDetectParser
extends CompositeParser {
    private static final long serialVersionUID = 6110455808615143122L;
    private Detector detector;

    public AutoDetectParser() {
        this(TikaConfig.getDefaultConfig());
    }

    public AutoDetectParser(Detector detector) {
        this(TikaConfig.getDefaultConfig());
        this.setDetector(detector);
    }

    public AutoDetectParser(Parser ... parsers) {
        this(new DefaultDetector(), parsers);
    }

    public AutoDetectParser(Detector detector, Parser ... parsers) {
        super(MediaTypeRegistry.getDefaultRegistry(), parsers);
        this.setDetector(detector);
    }

    public AutoDetectParser(TikaConfig config) {
        super(config.getMediaTypeRegistry(), config.getParser());
        this.setDetector(config.getDetector());
    }

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(Detector detector) {
        this.detector = detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        try {
            TikaInputStream tis = TikaInputStream.get(stream, tmp);
            MediaType type = this.detector.detect(tis, metadata);
            metadata.set("Content-Type", type.toString());
            SecureContentHandler sch = handler != null ? new SecureContentHandler(handler, tis) : null;
            try {
                super.parse(tis, sch, metadata, context);
            }
            catch (SAXException e) {
                sch.throwIfCauseOf(e);
                throw e;
            }
        }
        finally {
            tmp.dispose();
        }
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, this);
        this.parse(stream, handler, metadata, context);
    }
}

