/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.logs.model;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import com.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.MetricTransformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutMetricFilterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String logGroupName;
    private String filterName;
    private String filterPattern;
    private ListWithAutoConstructFlag<MetricTransformation> metricTransformations;

    public PutMetricFilterRequest() {
    }

    public PutMetricFilterRequest(String logGroupName, String filterName, String filterPattern, List<MetricTransformation> metricTransformations) {
        this.setLogGroupName(logGroupName);
        this.setFilterName(filterName);
        this.setFilterPattern(filterPattern);
        this.setMetricTransformations(metricTransformations);
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public PutMetricFilterRequest withLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
        return this;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public PutMetricFilterRequest withFilterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public PutMetricFilterRequest withFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
        return this;
    }

    public List<MetricTransformation> getMetricTransformations() {
        if (this.metricTransformations == null) {
            this.metricTransformations = new ListWithAutoConstructFlag();
            this.metricTransformations.setAutoConstruct(true);
        }
        return this.metricTransformations;
    }

    public void setMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        if (metricTransformations == null) {
            this.metricTransformations = null;
            return;
        }
        ListWithAutoConstructFlag metricTransformationsCopy = new ListWithAutoConstructFlag(metricTransformations.size());
        metricTransformationsCopy.addAll(metricTransformations);
        this.metricTransformations = metricTransformationsCopy;
    }

    public PutMetricFilterRequest withMetricTransformations(MetricTransformation ... metricTransformations) {
        if (this.getMetricTransformations() == null) {
            this.setMetricTransformations(new ArrayList<MetricTransformation>(metricTransformations.length));
        }
        for (MetricTransformation value : metricTransformations) {
            this.getMetricTransformations().add(value);
        }
        return this;
    }

    public PutMetricFilterRequest withMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        if (metricTransformations == null) {
            this.metricTransformations = null;
        } else {
            ListWithAutoConstructFlag metricTransformationsCopy = new ListWithAutoConstructFlag(metricTransformations.size());
            metricTransformationsCopy.addAll(metricTransformations);
            this.metricTransformations = metricTransformationsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: " + this.getLogGroupName() + ",");
        }
        if (this.getFilterName() != null) {
            sb.append("FilterName: " + this.getFilterName() + ",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: " + this.getFilterPattern() + ",");
        }
        if (this.getMetricTransformations() != null) {
            sb.append("MetricTransformations: " + this.getMetricTransformations());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterName() == null ? 0 : this.getFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getMetricTransformations() == null ? 0 : this.getMetricTransformations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricFilterRequest)) {
            return false;
        }
        PutMetricFilterRequest other = (PutMetricFilterRequest)obj;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getFilterName() == null ^ this.getFilterName() == null) {
            return false;
        }
        if (other.getFilterName() != null && !other.getFilterName().equals(this.getFilterName())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getMetricTransformations() == null ^ this.getMetricTransformations() == null) {
            return false;
        }
        return other.getMetricTransformations() == null || other.getMetricTransformations().equals(this.getMetricTransformations());
    }

    @Override
    public PutMetricFilterRequest clone() {
        return (PutMetricFilterRequest)super.clone();
    }
}

