/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.services.s3.model.ObjectMetadata;
import java.util.Map;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;

public class S3StorageObjectMetadata
implements StorageObjectMetadata {
    private ObjectMetadata s3Metadata;

    public S3StorageObjectMetadata(ObjectMetadata s3Metadata) {
        if (s3Metadata == null) {
            throw new IllegalArgumentException("s3Metadata must not be null");
        }
        this.s3Metadata = s3Metadata;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return SnowflakeUtil.createCaseInsensitiveMap(this.s3Metadata.getUserMetadata());
    }

    @Override
    public long getContentLength() {
        return this.s3Metadata.getContentLength();
    }

    @Override
    public void setContentLength(long contentLength) {
        this.s3Metadata.setContentLength(contentLength);
    }

    @Override
    public void addUserMetadata(String key, String value) {
        this.s3Metadata.addUserMetadata(key, value);
    }

    @Override
    public void setContentEncoding(String encoding) {
        this.s3Metadata.setContentEncoding(encoding);
    }

    @Override
    public String getContentEncoding() {
        return this.s3Metadata.getContentEncoding();
    }
}

