/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;

class GcmEncryptionProvider {
    private static final int TAG_LENGTH_IN_BITS = 128;
    private static final int IV_LENGTH_IN_BYTES = 12;
    private static final String AES = "AES";
    private static final String FILE_CIPHER = "AES/GCM/NoPadding";
    private static final String KEY_CIPHER = "AES/GCM/NoPadding";
    private static final int BUFFER_SIZE = 0x800000;
    private static final ThreadLocal<SecureRandom> random;
    private static final Base64.Decoder base64Decoder;

    GcmEncryptionProvider() {
    }

    static InputStream encrypt(StorageObjectMetadata meta, long originalContentLength, InputStream src, RemoteStoreFileEncryptionMaterial encMat, SnowflakeStorageClient client, byte[] dataAad, byte[] keyAad) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        byte[] kek = base64Decoder.decode(encMat.getQueryStageMasterKey());
        int keySize = kek.length;
        byte[] keyBytes = new byte[keySize];
        byte[] dataIvBytes = new byte[12];
        byte[] keyIvBytes = new byte[12];
        GcmEncryptionProvider.initRandomIvsAndFileKey(dataIvBytes, keyIvBytes, keyBytes);
        byte[] encryptedKey = GcmEncryptionProvider.encryptKey(kek, keyBytes, keyIvBytes, keyAad);
        CipherInputStream cis = GcmEncryptionProvider.encryptContent(src, keyBytes, dataIvBytes, dataAad);
        GcmEncryptionProvider.addEncryptionMetadataToStorageClient(meta, originalContentLength, encMat, client, keySize, encryptedKey, dataIvBytes, keyIvBytes, keyAad, dataAad);
        return cis;
    }

    private static void initRandomIvsAndFileKey(byte[] dataIvData, byte[] fileKeyIvData, byte[] fileKeyBytes) {
        random.get().nextBytes(dataIvData);
        random.get().nextBytes(fileKeyIvData);
        random.get().nextBytes(fileKeyBytes);
    }

    private static byte[] encryptKey(byte[] kekBytes, byte[] keyBytes, byte[] keyIvData, byte[] aad) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        SecretKeySpec kek = new SecretKeySpec(kekBytes, 0, kekBytes.length, AES);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, keyIvData);
        Cipher keyCipher = Cipher.getInstance("AES/GCM/NoPadding");
        keyCipher.init(1, (Key)kek, gcmParameterSpec);
        if (aad != null) {
            keyCipher.updateAAD(aad);
        }
        return keyCipher.doFinal(keyBytes);
    }

    private static CipherInputStream encryptContent(InputStream src, byte[] keyBytes, byte[] dataIvBytes, byte[] aad) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException {
        SecretKeySpec fileKey = new SecretKeySpec(keyBytes, 0, keyBytes.length, AES);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, dataIvBytes);
        Cipher fileCipher = Cipher.getInstance("AES/GCM/NoPadding");
        fileCipher.init(1, (Key)fileKey, gcmParameterSpec);
        if (aad != null) {
            fileCipher.updateAAD(aad);
        }
        return new CipherInputStream(src, fileCipher);
    }

    private static void addEncryptionMetadataToStorageClient(StorageObjectMetadata meta, long contentLength, RemoteStoreFileEncryptionMaterial encMat, SnowflakeStorageClient client, int keySize, byte[] encryptedKey, byte[] dataIvData, byte[] keyIvData, byte[] keyAad, byte[] dataAad) {
        MatDesc matDesc = new MatDesc(encMat.getSmkId(), encMat.getQueryId(), keySize * 8);
        client.addEncryptionMetadataForGcm(meta, matDesc, encryptedKey, dataIvData, keyIvData, keyAad, dataAad, contentLength);
    }

    static void decryptFile(File file, String encryptedFileKeyBase64, String dataIvBase64, String keyIvBase64, RemoteStoreFileEncryptionMaterial encMat, String dataAadBase64, String keyAadBase64) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException, NoSuchPaddingException, NoSuchAlgorithmException {
        byte[] encryptedKeyBytes = base64Decoder.decode(encryptedFileKeyBase64);
        byte[] dataIvBytes = base64Decoder.decode(dataIvBase64);
        byte[] keyIvBytes = base64Decoder.decode(keyIvBase64);
        byte[] kekBytes = base64Decoder.decode(encMat.getQueryStageMasterKey());
        byte[] keyAad = base64Decoder.decode(keyAadBase64);
        byte[] dataAad = base64Decoder.decode(dataAadBase64);
        byte[] keyBytes = GcmEncryptionProvider.decryptKey(kekBytes, keyIvBytes, encryptedKeyBytes, keyAad);
        GcmEncryptionProvider.decryptContentFromFile(file, keyBytes, dataIvBytes, dataAad);
    }

    static InputStream decryptStream(InputStream inputStream, String encryptedKeyBase64, String dataIvBase64, String keyIvBase64, RemoteStoreFileEncryptionMaterial encMat, String dataAad, String keyAad) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException {
        byte[] encryptedKeyBytes = base64Decoder.decode(encryptedKeyBase64);
        byte[] ivBytes = base64Decoder.decode(dataIvBase64);
        byte[] kekIvBytes = base64Decoder.decode(keyIvBase64);
        byte[] dataAadBytes = base64Decoder.decode(dataAad);
        byte[] keyAadBytes = base64Decoder.decode(keyAad);
        byte[] kekBytes = base64Decoder.decode(encMat.getQueryStageMasterKey());
        byte[] fileKeyBytes = GcmEncryptionProvider.decryptKey(kekBytes, kekIvBytes, encryptedKeyBytes, keyAadBytes);
        return GcmEncryptionProvider.decryptContentFromStream(inputStream, ivBytes, fileKeyBytes, dataAadBytes);
    }

    private static CipherInputStream decryptContentFromStream(InputStream inputStream, byte[] ivBytes, byte[] fileKeyBytes, byte[] aad) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException {
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, ivBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, AES);
        Cipher fileCipher = Cipher.getInstance("AES/GCM/NoPadding");
        fileCipher.init(2, (Key)fileKey, gcmParameterSpec);
        if (aad != null) {
            fileCipher.updateAAD(aad);
        }
        return new CipherInputStream(inputStream, fileCipher);
    }

    private static void decryptContentFromFile(File file, byte[] fileKeyBytes, byte[] cekIvBytes, byte[] aad) throws InvalidKeyException, InvalidAlgorithmParameterException, IOException, NoSuchPaddingException, NoSuchAlgorithmException {
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, AES);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, cekIvBytes);
        byte[] buffer = new byte[0x800000];
        Cipher fileCipher = Cipher.getInstance("AES/GCM/NoPadding");
        fileCipher.init(2, (Key)fileKey, gcmParameterSpec);
        if (aad != null) {
            fileCipher.updateAAD(aad);
        }
        long totalBytesRead = 0L;
        try (InputStream is = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
             CipherInputStream cis = new CipherInputStream(is, fileCipher);
             OutputStream os = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE);){
            int bytesRead;
            while ((bytesRead = ((InputStream)cis).read(buffer)) > -1) {
                os.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file, true);
             FileChannel fc = fos.getChannel();){
            fc.truncate(totalBytesRead);
        }
    }

    private static byte[] decryptKey(byte[] kekBytes, byte[] ivBytes, byte[] keyBytes, byte[] aad) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        SecretKeySpec kek = new SecretKeySpec(kekBytes, 0, kekBytes.length, AES);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, ivBytes);
        Cipher keyCipher = Cipher.getInstance("AES/GCM/NoPadding");
        keyCipher.init(2, (Key)kek, gcmParameterSpec);
        if (aad != null) {
            keyCipher.updateAAD(aad);
        }
        return keyCipher.doFinal(keyBytes);
    }

    static {
        new ThreadLocal();
        random = ThreadLocal.withInitial(SecureRandom::new);
        base64Decoder = Base64.getDecoder();
    }
}

