/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.github.luben.zstd.ZstdInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.jdbc.DefaultResultStreamProvider;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.FileCompressionType;
import org.apache.http.Header;

class CompressedStreamFactory {
    private static final int STREAM_BUFFER_SIZE = 0x100000;

    CompressedStreamFactory() {
    }

    public InputStream createBasedOnEncodingHeader(InputStream is, Header encoding) throws IOException, SnowflakeSQLException {
        if (encoding != null) {
            if (FileCompressionType.GZIP.name().equalsIgnoreCase(encoding.getValue())) {
                return new GZIPInputStream(is, 0x100000);
            }
            if (FileCompressionType.ZSTD.name().equalsIgnoreCase(encoding.getValue())) {
                return new ZstdInputStream(is);
            }
            throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Exception: unexpected compression got " + encoding.getValue());
        }
        return DefaultResultStreamProvider.detectGzipAndGetStream(is);
    }
}

