/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class Event {
    private static final SFLogger logger = SFLoggerFactory.getLogger(Event.class);
    private static final String EVENT_DUMP_FILE_NAME = "sf_event_";
    private static final String EVENT_DUMP_FILE_EXT = ".dmp.gz";
    private EventType type;
    private String message;

    public Event(EventType type, String message) {
        Preconditions.checkArgument((type.getEventClass() == this.getClass() ? 1 : 0) != 0);
        this.type = type;
        this.message = message;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void writeEventDumpLine(String message) {
        String eventDumpPath = EventUtil.getDumpPathPrefix() + "/" + EVENT_DUMP_FILE_NAME + EventUtil.getDumpFileId() + EVENT_DUMP_FILE_EXT;
        if (new File(eventDumpPath).length() < EventUtil.getmaxDumpFileSizeBytes()) {
            try {
                GZIPOutputStream outStream = new GZIPOutputStream(new FileOutputStream(eventDumpPath, true));
                PrintWriter eventDumper = new PrintWriter(outStream, true);
                eventDumper.println(message);
                eventDumper.flush();
                eventDumper.close();
            }
            catch (IOException ex) {
                logger.error("Could not open Event dump file {}, exception:{}", eventDumpPath, ex.getMessage());
            }
        } else {
            logger.error("Failed to dump Event because dump file is too large. Delete dump file or increase maximum dump file size.", false);
        }
    }

    public abstract void flush();

    public static enum EventType {
        NETWORK_ERROR(1, "NETWORK ERROR", BasicEvent.class),
        STATE_TRANSITION(2, "STATE TRANSITION", BasicEvent.class),
        NONE(100, "NONE", BasicEvent.class);

        private final int id;
        private final String description;
        private final Class<? extends Event> eventClass;

        public int getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public Class<? extends Event> getEventClass() {
            return this.eventClass;
        }

        private EventType(int id, String description, Class<? extends Event> eventClass) {
            this.id = id;
            this.description = description;
            this.eventClass = eventClass;
        }
    }
}

