/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.util;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.AwsAttestationService;
import net.snowflake.client.core.auth.wif.PlatformDetectionUtil;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPut;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.EnvironmentProvider;
import net.snowflake.client.util.Platform;
import net.snowflake.client.util.SnowflakeEnvironmentProvider;

@SnowflakeJdbcInternalApi
public class PlatformDetector {
    private static final SFLogger logger = SFLoggerFactory.getLogger(PlatformDetector.class);
    private static final int DEFAULT_DETECTION_TIMEOUT_MS = 200;
    private static List<String> cachedDetectedPlatforms = null;
    private static final String AWS_LAMBDA_TASK_ROOT = "LAMBDA_TASK_ROOT";
    private static final String AZURE_FUNCTIONS_WORKER_RUNTIME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String AZURE_FUNCTIONS_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION";
    private static final String AZURE_WEBJOBS_STORAGE = "AzureWebJobsStorage";
    private static final String AZURE_IDENTITY_HEADER = "IDENTITY_HEADER";
    private static final String GCP_K_SERVICE = "K_SERVICE";
    private static final String GCP_K_REVISION = "K_REVISION";
    private static final String GCP_K_CONFIGURATION = "K_CONFIGURATION";
    private static final String GCP_CLOUD_RUN_JOB = "CLOUD_RUN_JOB";
    private static final String GCP_CLOUD_RUN_EXECUTION = "CLOUD_RUN_EXECUTION";
    private static final String GITHUB_ACTIONS = "GITHUB_ACTIONS";
    private static final String DEFAULT_METADATA_SERVICE_BASE_URL = "http://169.254.169.254";
    private static final String DEFAULT_GCP_METADATA_BASE_URL = "http://metadata.google.internal";
    private static final String AWS_METADATA_TOKEN_TTL_HEADER = "X-aws-ec2-metadata-token-ttl-seconds";
    private static final String AWS_METADATA_TOKEN_HEADER = "X-aws-ec2-metadata-token";
    private static final String AWS_METADATA_TOKEN_TTL_VALUE = "21600";
    private static final String AZURE_METADATA_HEADER = "Metadata";
    private static final String AZURE_METADATA_VALUE = "True";
    private static final String GCP_METADATA_FLAVOR_HEADER = "Metadata-Flavor";
    private static final String GCP_METADATA_FLAVOR_VALUE = "Google";
    private static final String AWS_TOKEN_ENDPOINT_PATH = "/latest/api/token";
    private static final String AWS_INSTANCE_IDENTITY_ENDPOINT_PATH = "/latest/dynamic/instance-identity/document";
    private static final String AZURE_INSTANCE_ENDPOINT_PATH = "/metadata/instance?api-version=2021-02-01";
    private static final String AZURE_IDENTITY_ENDPOINT_PATH = "/metadata/identity/oauth2/token?api-version=2018-02-01&resource=";
    private static final String GCP_SERVICE_ACCOUNT_ENDPOINT_PATH = "/computeMetadata/v1/instance/service-accounts/default/email";
    private static final String AZURE_MANAGEMENT_RESOURCE_URL = "https://management.azure.com";
    private static final String TIMEOUT_SUFFIX = "_timeout";
    private final String awsMetadataBaseUrl;
    private final String azureMetadataBaseUrl;
    private final String gcpMetadataBaseUrl;
    private final EnvironmentProvider environmentProvider;

    public PlatformDetector() {
        this.awsMetadataBaseUrl = DEFAULT_METADATA_SERVICE_BASE_URL;
        this.azureMetadataBaseUrl = DEFAULT_METADATA_SERVICE_BASE_URL;
        this.gcpMetadataBaseUrl = DEFAULT_GCP_METADATA_BASE_URL;
        this.environmentProvider = new SnowflakeEnvironmentProvider();
    }

    PlatformDetector(String awsMetadataBaseUrl, String azureMetadataBaseUrl, String gcpMetadataBaseUrl, EnvironmentProvider environmentProvider) {
        this.awsMetadataBaseUrl = awsMetadataBaseUrl;
        this.azureMetadataBaseUrl = azureMetadataBaseUrl;
        this.gcpMetadataBaseUrl = gcpMetadataBaseUrl;
        this.environmentProvider = environmentProvider;
    }

    public static synchronized List<String> getCachedPlatformDetection() {
        if (cachedDetectedPlatforms != null) {
            return cachedDetectedPlatforms;
        }
        logger.debug("Platform detection cache miss. Initializing with default timeout: {}ms", 200);
        PlatformDetector detector = new PlatformDetector();
        AwsAttestationService attestationService = new AwsAttestationService();
        List<String> result = PlatformDetector.detectPlatformsAndCache(detector, attestationService);
        logger.debug("Platform detection cache initialized: {}", result);
        return result;
    }

    static synchronized List<String> detectPlatformsAndCache(PlatformDetector detector, AwsAttestationService attestationService) {
        List<String> detectedPlatforms = detector.detectPlatforms(200, attestationService);
        cachedDetectedPlatforms = Collections.unmodifiableList(detectedPlatforms);
        return cachedDetectedPlatforms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> detectPlatforms(Integer platformDetectionTimeoutMs, AwsAttestationService attestationService) {
        try {
            int timeoutMs = platformDetectionTimeoutMs != null ? platformDetectionTimeoutMs : 200;
            HashMap<Platform, DetectionState> platforms = new HashMap<Platform, DetectionState>();
            platforms.put(Platform.IS_AWS_LAMBDA, this.isAwsLambda());
            platforms.put(Platform.IS_AZURE_FUNCTION, this.isAzureFunction());
            platforms.put(Platform.IS_GCE_CLOUD_RUN_SERVICE, this.isGcpCloudRunService());
            platforms.put(Platform.IS_GCE_CLOUD_RUN_JOB, this.isGcpCloudRunJob());
            platforms.put(Platform.IS_GITHUB_ACTION, this.isGithubAction());
            if (timeoutMs != 0) {
                ExecutorService executor = Executors.newFixedThreadPool(6);
                try {
                    HashMap<Platform, CompletableFuture<DetectionState>> futures = new HashMap<Platform, CompletableFuture<DetectionState>>();
                    futures.put(Platform.IS_EC2_INSTANCE, CompletableFuture.supplyAsync(() -> this.isEc2Instance(timeoutMs), executor));
                    futures.put(Platform.HAS_AWS_IDENTITY, CompletableFuture.supplyAsync(() -> PlatformDetector.hasAwsIdentity(attestationService, timeoutMs), executor));
                    futures.put(Platform.IS_AZURE_VM, CompletableFuture.supplyAsync(() -> this.isAzureVm(timeoutMs), executor));
                    futures.put(Platform.HAS_AZURE_MANAGED_IDENTITY, CompletableFuture.supplyAsync(() -> this.hasAzureManagedIdentity(timeoutMs), executor));
                    futures.put(Platform.IS_GCE_VM, CompletableFuture.supplyAsync(() -> this.isGceVm(timeoutMs), executor));
                    futures.put(Platform.HAS_GCP_IDENTITY, CompletableFuture.supplyAsync(() -> this.hasGcpIdentity(timeoutMs), executor));
                    for (Map.Entry entry : futures.entrySet()) {
                        try {
                            DetectionState result = (DetectionState)((Object)((CompletableFuture)entry.getValue()).get(timeoutMs, TimeUnit.MILLISECONDS));
                            platforms.put((Platform)((Object)entry.getKey()), result);
                        }
                        catch (TimeoutException e) {
                            logger.debug("Platform detection timed out for: {}", entry.getKey());
                            platforms.put((Platform)((Object)entry.getKey()), DetectionState.TIMEOUT);
                            ((CompletableFuture)entry.getValue()).cancel(true);
                        }
                        catch (Exception e) {
                            logger.debug("Platform detection failed for {}: {}", entry.getKey(), e.getMessage());
                            platforms.put((Platform)((Object)entry.getKey()), DetectionState.NOT_DETECTED);
                            ((CompletableFuture)entry.getValue()).cancel(true);
                        }
                    }
                }
                finally {
                    executor.shutdown();
                    try {
                        if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                            executor.shutdownNow();
                        }
                    }
                    catch (InterruptedException e) {
                        executor.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                }
            }
            List<String> detectedPlatforms = PlatformDetector.getDetectedPlatforms(platforms);
            logger.debug("Platform detection completed. Detected platforms: {}", detectedPlatforms);
            return detectedPlatforms;
        }
        catch (Exception e) {
            logger.debug("Platform detection failed with exception: {}", e.getMessage());
            return new ArrayList<String>();
        }
    }

    private static List<String> getDetectedPlatforms(Map<Platform, DetectionState> platforms) {
        ArrayList<String> detectedPlatforms = new ArrayList<String>();
        for (Map.Entry<Platform, DetectionState> entry : platforms.entrySet()) {
            Platform platform = entry.getKey();
            DetectionState state = entry.getValue();
            if (state == DetectionState.DETECTED) {
                detectedPlatforms.add(platform.getValue());
                continue;
            }
            if (state != DetectionState.TIMEOUT) continue;
            detectedPlatforms.add(platform.getValue() + TIMEOUT_SUFFIX);
        }
        return detectedPlatforms;
    }

    private static boolean isTimeoutException(Exception e) {
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof TimeoutException) {
            return true;
        }
        if (e instanceof SnowflakeSQLException) {
            String message = e.getMessage();
            return message != null && (message.contains("timeout") || message.contains("timed out") || message.contains("elapsed time") || message.toLowerCase().contains("timeout"));
        }
        Throwable cause = e.getCause();
        return cause instanceof SocketTimeoutException || cause instanceof TimeoutException;
    }

    private static String executeHttpGet(String uri, Map<String, String> headers, int timeoutMs) throws SnowflakeSQLException, IOException {
        HttpGet request = new HttpGet(uri);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
        return PlatformDetectionUtil.performPlatformDetectionRequest(request, timeoutMs);
    }

    private static String executeHttpPut(String uri, Map<String, String> headers, int timeoutMs) throws SnowflakeSQLException, IOException {
        HttpPut request = new HttpPut(uri);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
        return PlatformDetectionUtil.performPlatformDetectionRequest(request, timeoutMs);
    }

    private DetectionState isEc2Instance(int timeoutMs) {
        block7: {
            try {
                String response;
                String token = null;
                try {
                    String tokenResponse = PlatformDetector.executeHttpPut(this.getAwsMetadataTokenEndpoint(), Collections.singletonMap(AWS_METADATA_TOKEN_TTL_HEADER, AWS_METADATA_TOKEN_TTL_VALUE), timeoutMs);
                    if (tokenResponse != null && !tokenResponse.trim().isEmpty()) {
                        token = tokenResponse.trim();
                        logger.debug("Successfully obtained IMDSv2 token", new Object[0]);
                    }
                }
                catch (Exception e) {
                    logger.debug("Failed to get IMDSv2 token, will try IMDSv1: {}", e.getMessage());
                }
                HashMap<String, String> headers = new HashMap<String, String>();
                if (token != null) {
                    headers.put(AWS_METADATA_TOKEN_HEADER, token);
                }
                if ((response = PlatformDetector.executeHttpGet(this.getAwsMetadataIdentityEndpoint(), headers, timeoutMs)) != null && !response.trim().isEmpty()) {
                    logger.debug("Successfully detected EC2 instance via metadata service", new Object[0]);
                    return DetectionState.DETECTED;
                }
            }
            catch (Exception e) {
                logger.debug("EC2 instance detection failed: {}", e.getMessage());
                if (!PlatformDetector.isTimeoutException(e)) break block7;
                return DetectionState.TIMEOUT;
            }
        }
        return DetectionState.NOT_DETECTED;
    }

    private DetectionState isAwsLambda() {
        return this.checkAllEnvironmentVariables(AWS_LAMBDA_TASK_ROOT) ? DetectionState.DETECTED : DetectionState.NOT_DETECTED;
    }

    private static DetectionState hasAwsIdentity(AwsAttestationService attestationService, int timeoutMs) {
        return PlatformDetectionUtil.hasValidAwsIdentityForWif(attestationService, timeoutMs) ? DetectionState.DETECTED : DetectionState.NOT_DETECTED;
    }

    private DetectionState isAzureVm(int timeoutMs) {
        block3: {
            try {
                Map<String, String> headers = Collections.singletonMap(AZURE_METADATA_HEADER, AZURE_METADATA_VALUE);
                String response = PlatformDetector.executeHttpGet(this.getAzureMetadataInstanceEndpoint(), headers, timeoutMs);
                if (response != null && !response.trim().isEmpty()) {
                    logger.debug("Successfully detected Azure VM via metadata service", new Object[0]);
                    return DetectionState.DETECTED;
                }
            }
            catch (Exception e) {
                logger.debug("Azure VM detection failed: {}", e.getMessage());
                if (!PlatformDetector.isTimeoutException(e)) break block3;
                return DetectionState.TIMEOUT;
            }
        }
        return DetectionState.NOT_DETECTED;
    }

    private DetectionState isAzureFunction() {
        return this.checkAllEnvironmentVariables(AZURE_FUNCTIONS_WORKER_RUNTIME, AZURE_FUNCTIONS_EXTENSION_VERSION, AZURE_WEBJOBS_STORAGE) ? DetectionState.DETECTED : DetectionState.NOT_DETECTED;
    }

    private DetectionState isManagedIdentityAvailableOnAzureVm(int timeoutMs, String resource) {
        block3: {
            try {
                String endpoint = this.getAzureManagedIdentityEndpoint(resource);
                Map<String, String> headers = Collections.singletonMap(AZURE_METADATA_HEADER, AZURE_METADATA_VALUE);
                String response = PlatformDetector.executeHttpGet(endpoint, headers, timeoutMs);
                if (response != null && !response.trim().isEmpty()) {
                    logger.debug("Successfully detected Azure managed identity", new Object[0]);
                    return DetectionState.DETECTED;
                }
            }
            catch (Exception e) {
                logger.debug("Azure managed identity detection failed: {}", e.getMessage());
                if (!PlatformDetector.isTimeoutException(e)) break block3;
                return DetectionState.TIMEOUT;
            }
        }
        return DetectionState.NOT_DETECTED;
    }

    private DetectionState hasAzureManagedIdentity(int timeoutMs) {
        if (this.isAzureFunction() == DetectionState.DETECTED && this.checkAllEnvironmentVariables(AZURE_IDENTITY_HEADER)) {
            logger.debug("Detected Azure managed identity via IDENTITY_HEADER environment variable", new Object[0]);
            return DetectionState.DETECTED;
        }
        return this.isManagedIdentityAvailableOnAzureVm(timeoutMs, AZURE_MANAGEMENT_RESOURCE_URL);
    }

    private DetectionState isGceVm(int timeoutMs) {
        try {
            Map<String, String> headers = Collections.singletonMap(GCP_METADATA_FLAVOR_HEADER, GCP_METADATA_FLAVOR_VALUE);
            String response = PlatformDetector.executeHttpGet(this.getGcpMetadataBaseEndpoint(), headers, timeoutMs);
            if (response != null) {
                logger.debug("Successfully detected GCE VM via metadata service", new Object[0]);
                return DetectionState.DETECTED;
            }
        }
        catch (Exception e) {
            logger.debug("GCE VM detection failed: {}", e.getMessage());
        }
        return DetectionState.NOT_DETECTED;
    }

    private DetectionState isGcpCloudRunService() {
        return this.checkAllEnvironmentVariables(GCP_K_SERVICE, GCP_K_REVISION, GCP_K_CONFIGURATION) ? DetectionState.DETECTED : DetectionState.NOT_DETECTED;
    }

    private DetectionState isGcpCloudRunJob() {
        return this.checkAllEnvironmentVariables(GCP_CLOUD_RUN_JOB, GCP_CLOUD_RUN_EXECUTION) ? DetectionState.DETECTED : DetectionState.NOT_DETECTED;
    }

    private DetectionState hasGcpIdentity(int timeoutMs) {
        block3: {
            try {
                Map<String, String> headers = Collections.singletonMap(GCP_METADATA_FLAVOR_HEADER, GCP_METADATA_FLAVOR_VALUE);
                String response = PlatformDetector.executeHttpGet(this.getGcpServiceAccountEndpoint(), headers, timeoutMs);
                if (response != null) {
                    logger.debug("Successfully detected GCP identity via metadata service", new Object[0]);
                    return DetectionState.DETECTED;
                }
            }
            catch (Exception e) {
                logger.debug("GCP identity detection failed: {}", e.getMessage());
                if (!PlatformDetector.isTimeoutException(e)) break block3;
                return DetectionState.TIMEOUT;
            }
        }
        return DetectionState.NOT_DETECTED;
    }

    private DetectionState isGithubAction() {
        return this.checkAllEnvironmentVariables(GITHUB_ACTIONS) ? DetectionState.DETECTED : DetectionState.NOT_DETECTED;
    }

    private boolean checkAllEnvironmentVariables(String ... variableNames) {
        if (variableNames == null || variableNames.length == 0) {
            return false;
        }
        for (String varName : variableNames) {
            String value = this.environmentProvider.getEnv(varName);
            if (value != null && !value.trim().isEmpty()) continue;
            logger.debug("Environment variable {} is not set or empty", varName);
            return false;
        }
        logger.debug("All environment variables are present: {}", Arrays.toString(variableNames));
        return true;
    }

    private String getAwsMetadataTokenEndpoint() {
        return this.awsMetadataBaseUrl + AWS_TOKEN_ENDPOINT_PATH;
    }

    private String getAwsMetadataIdentityEndpoint() {
        return this.awsMetadataBaseUrl + AWS_INSTANCE_IDENTITY_ENDPOINT_PATH;
    }

    private String getAzureMetadataInstanceEndpoint() {
        return this.azureMetadataBaseUrl + AZURE_INSTANCE_ENDPOINT_PATH;
    }

    private String getAzureManagedIdentityEndpoint(String resource) {
        return this.azureMetadataBaseUrl + AZURE_IDENTITY_ENDPOINT_PATH + resource;
    }

    private String getGcpMetadataBaseEndpoint() {
        return this.gcpMetadataBaseUrl;
    }

    private String getGcpServiceAccountEndpoint() {
        return this.gcpMetadataBaseUrl + GCP_SERVICE_ACCOUNT_ENDPOINT_PATH;
    }

    private static enum DetectionState {
        DETECTED,
        NOT_DETECTED,
        TIMEOUT;

    }
}

