/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security.trust;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;

public final class CertificateUtils {
    public static boolean isXdsSniEnabled = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_XDS_SNI", true);
    public static boolean useChannelAuthorityIfNoSniApplicable = GrpcUtil.getFlag("GRPC_USE_CHANNEL_AUTHORITY_IF_NO_SNI_APPLICABLE", false);

    static X509Certificate[] toX509Certificates(File file) throws CertificateException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            X509Certificate[] x509CertificateArray;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                x509CertificateArray = CertificateUtils.toX509Certificates(bis);
            }
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException, IOException {
        return net.snowflake.client.jdbc.internal.grpc.util.CertificateUtils.getX509Certificates(inputStream);
    }

    public static PrivateKey getPrivateKey(InputStream inputStream) throws Exception {
        return net.snowflake.client.jdbc.internal.grpc.util.CertificateUtils.getPrivateKey(inputStream);
    }

    private CertificateUtils() {
    }
}

