/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security;

import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.concurrent.Executor;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.Closeable;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;

@Internal
public abstract class SslContextProvider
implements Closeable {
    protected final EnvoyServerProtoData.BaseTlsContext tlsContext;

    protected SslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext) {
        this.tlsContext = Preconditions.checkNotNull(tlsContext, "tlsContext");
    }

    protected CommonTlsContext getCommonTlsContext() {
        return this.tlsContext.getCommonTlsContext();
    }

    protected void setClientAuthValues(SslContextBuilder sslContextBuilder, XdsTrustManagerFactory xdsTrustManagerFactory) throws CertificateException, IOException, CertStoreException {
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = this.getDownstreamTlsContext();
        if (xdsTrustManagerFactory != null) {
            sslContextBuilder.trustManager(xdsTrustManagerFactory);
            sslContextBuilder.clientAuth(downstreamTlsContext.isRequireClientCertificate() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        } else {
            sslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    public EnvoyServerProtoData.DownstreamTlsContext getDownstreamTlsContext() {
        Preconditions.checkState(this.tlsContext instanceof EnvoyServerProtoData.DownstreamTlsContext, "expected DownstreamTlsContext");
        return (EnvoyServerProtoData.DownstreamTlsContext)this.tlsContext;
    }

    public EnvoyServerProtoData.UpstreamTlsContext getUpstreamTlsContext() {
        Preconditions.checkState(this.tlsContext instanceof EnvoyServerProtoData.UpstreamTlsContext, "expected UpstreamTlsContext");
        return (EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext;
    }

    @Override
    public abstract void close();

    public abstract void addCallback(Callback var1);

    protected final void performCallback(final SslContextGetter sslContextGetter, final Callback callback) {
        Preconditions.checkNotNull(sslContextGetter, "sslContextGetter");
        Preconditions.checkNotNull(callback, "callback");
        callback.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTm = sslContextGetter.get();
                    callback.updateSslContextAndExtendedX509TrustManager(sslContextAndTm);
                }
                catch (Throwable e) {
                    callback.onException(e);
                }
            }
        });
    }

    protected static interface SslContextGetter {
        public AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> get() throws Exception;
    }

    @VisibleForTesting
    public static abstract class Callback {
        private final Executor executor;

        protected Callback(Executor executor) {
            this.executor = executor;
        }

        @VisibleForTesting
        public Executor getExecutor() {
            return this.executor;
        }

        @VisibleForTesting
        public abstract void updateSslContextAndExtendedX509TrustManager(AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> var1);

        @VisibleForTesting
        protected abstract void onException(Throwable var1);
    }
}

