/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security;

import java.security.cert.CertStoreException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.grpc.Attributes;
import net.snowflake.client.jdbc.internal.grpc.internal.ObjectPool;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.util.AsciiString;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.XdsInternalAttributes;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProviderSupplier;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.trust.CertificateUtils;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@VisibleForTesting
public final class SecurityProtocolNegotiators {
    private static final Logger logger = Logger.getLogger(SecurityProtocolNegotiators.class.getName());
    private static final AsciiString SCHEME = AsciiString.of("http");
    public static final Attributes.Key<SslContextProviderSupplier> ATTR_SERVER_SSL_CONTEXT_PROVIDER_SUPPLIER = Attributes.Key.create("net.snowflake.client.jdbc.internal.grpc.xds.internal.security.server.sslContextProviderSupplier");
    public static final Attributes.Key<SslContextProviderSupplier> ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER = Attributes.Key.create("net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProviderSupplier");

    private SecurityProtocolNegotiators() {
    }

    public static InternalProtocolNegotiator.ClientFactory clientProtocolNegotiatorFactory(@Nullable InternalProtocolNegotiator.ClientFactory fallbackNegotiator) {
        return new ClientFactory(fallbackNegotiator);
    }

    public static InternalProtocolNegotiator.ServerFactory serverProtocolNegotiatorFactory(@Nullable InternalProtocolNegotiator.ServerFactory fallbackNegotiator) {
        return new ServerFactory(fallbackNegotiator);
    }

    @VisibleForTesting
    static final class ServerSecurityHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final SslContextProviderSupplier sslContextProviderSupplier;

        ServerSecurityHandler(GrpcHttp2ConnectionHandler grpcHandler, SslContextProviderSupplier sslContextProviderSupplier) {
            super(new ChannelHandlerAdapter(){

                @Override
                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove(this);
                }
            }, grpcHandler.getNegotiationLogger());
            Preconditions.checkNotNull(grpcHandler, "net.snowflake.client.jdbc.internal.grpcHandler");
            this.grpcHandler = grpcHandler;
            this.sslContextProviderSupplier = sslContextProviderSupplier;
        }

        @Override
        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, bufferReads);
            this.sslContextProviderSupplier.updateSslContext(new SslContextProvider.Callback(ctx.executor()){

                @Override
                public void updateSslContextAndExtendedX509TrustManager(AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTm) {
                    ChannelHandler handler = InternalProtocolNegotiators.serverTls(sslContextAndTm.getKey()).newHandler(grpcHandler);
                    if (!ctx.isRemoved()) {
                        ctx.pipeline().addAfter(ctx.name(), null, handler);
                        this.fireProtocolNegotiationEvent(ctx);
                        ctx.pipeline().remove(bufferReads);
                    }
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            }, false);
        }
    }

    @VisibleForTesting
    static final class HandlerPickerHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        HandlerPickerHandler(GrpcHttp2ConnectionHandler grpcHandler, @Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.grpcHandler = Preconditions.checkNotNull(grpcHandler, "net.snowflake.client.jdbc.internal.grpcHandler");
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                ProtocolNegotiationEvent pne = (ProtocolNegotiationEvent)evt;
                SslContextProviderSupplier sslContextProviderSupplier = InternalProtocolNegotiationEvent.getAttributes(pne).get(ATTR_SERVER_SSL_CONTEXT_PROVIDER_SUPPLIER);
                if (sslContextProviderSupplier == null) {
                    logger.log(Level.FINE, "No sslContextProviderSupplier found in filterChainMatch for connection from {0} to {1}", new Object[]{ctx.channel().remoteAddress(), ctx.channel().localAddress()});
                    if (this.fallbackProtocolNegotiator == null) {
                        ctx.fireExceptionCaught(new CertStoreException("No certificate source found!"));
                        return;
                    }
                    logger.log(Level.FINE, "Using fallback credentials for connection from {0} to {1}", new Object[]{ctx.channel().remoteAddress(), ctx.channel().localAddress()});
                    ctx.pipeline().replace(this, null, this.fallbackProtocolNegotiator.newHandler(this.grpcHandler));
                    ctx.fireUserEventTriggered(pne);
                    return;
                }
                ctx.pipeline().replace(this, null, (ChannelHandler)new ServerSecurityHandler(this.grpcHandler, sslContextProviderSupplier));
                ctx.fireUserEventTriggered(pne);
                return;
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    private static final class ServerSecurityProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        @VisibleForTesting
        public ServerSecurityProtocolNegotiator(@Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            return new HandlerPickerHandler(grpcHandler, this.fallbackProtocolNegotiator);
        }

        @Override
        public void close() {
        }
    }

    @VisibleForTesting
    static final class ClientSecurityHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final SslContextProviderSupplier sslContextProviderSupplier;
        private final String sni;
        private final boolean autoSniSanValidationDoesNotApply;

        ClientSecurityHandler(GrpcHttp2ConnectionHandler grpcHandler, SslContextProviderSupplier sslContextProviderSupplier, String endpointHostname) {
            super(new ChannelHandlerAdapter(){

                @Override
                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove(this);
                }
            }, grpcHandler.getNegotiationLogger());
            Preconditions.checkNotNull(grpcHandler, "net.snowflake.client.jdbc.internal.grpcHandler");
            this.grpcHandler = grpcHandler;
            this.sslContextProviderSupplier = sslContextProviderSupplier;
            EnvoyServerProtoData.BaseTlsContext tlsContext = sslContextProviderSupplier.getTlsContext();
            EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = (EnvoyServerProtoData.UpstreamTlsContext)tlsContext;
            if (CertificateUtils.isXdsSniEnabled) {
                String sniToUse;
                String string = sniToUse = upstreamTlsContext.getAutoHostSni() && !Strings.isNullOrEmpty(endpointHostname) ? endpointHostname : upstreamTlsContext.getSni();
                if (sniToUse.isEmpty() && CertificateUtils.useChannelAuthorityIfNoSniApplicable) {
                    sniToUse = grpcHandler.getAuthority();
                    this.autoSniSanValidationDoesNotApply = true;
                } else {
                    this.autoSniSanValidationDoesNotApply = false;
                }
                this.sni = sniToUse;
            } else {
                this.sni = grpcHandler.getAuthority();
                this.autoSniSanValidationDoesNotApply = false;
            }
        }

        @VisibleForTesting
        String getSni() {
            return this.sni;
        }

        @Override
        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, bufferReads);
            this.sslContextProviderSupplier.updateSslContext(new SslContextProvider.Callback(ctx.executor()){

                @Override
                public void updateSslContextAndExtendedX509TrustManager(AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTm) {
                    if (ctx.isRemoved()) {
                        return;
                    }
                    logger.log(Level.FINEST, "ClientSecurityHandler.updateSslContext authority={0}, ctx.name={1}", new Object[]{grpcHandler.getAuthority(), ctx.name()});
                    ChannelHandler handler = InternalProtocolNegotiators.tls(sslContextAndTm.getKey(), sni, sslContextAndTm.getValue()).newHandler(grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove(bufferReads);
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            }, this.autoSniSanValidationDoesNotApply);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    private static class BufferReadsHandler
    extends ChannelInboundHandlerAdapter {
        private final List<Object> reads = new ArrayList<Object>();
        private boolean readComplete;

        private BufferReadsHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.reads.add(msg);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            this.readComplete = true;
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            for (Object msg : this.reads) {
                super.channelRead(ctx, msg);
            }
            if (this.readComplete) {
                super.channelReadComplete(ctx);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    @VisibleForTesting
    static final class ClientSecurityProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        ClientSecurityProtocolNegotiator(@Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            SslContextProviderSupplier localSslContextProviderSupplier = grpcHandler.getEagAttributes().get(ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER);
            if (localSslContextProviderSupplier == null) {
                Preconditions.checkNotNull(this.fallbackProtocolNegotiator, "No TLS config and no fallbackProtocolNegotiator!");
                return this.fallbackProtocolNegotiator.newHandler(grpcHandler);
            }
            return new ClientSecurityHandler(grpcHandler, localSslContextProviderSupplier, grpcHandler.getEagAttributes().get(XdsInternalAttributes.ATTR_ADDRESS_NAME));
        }

        @Override
        public void close() {
        }
    }

    private static final class ClientFactory
    implements InternalProtocolNegotiator.ClientFactory {
        private final InternalProtocolNegotiator.ClientFactory fallbackProtocolNegotiator;

        private ClientFactory(InternalProtocolNegotiator.ClientFactory fallbackNegotiator) {
            this.fallbackProtocolNegotiator = fallbackNegotiator;
        }

        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return new ClientSecurityProtocolNegotiator(this.fallbackProtocolNegotiator.newNegotiator());
        }

        @Override
        public int getDefaultPort() {
            return 443;
        }
    }

    private static final class ServerFactory
    implements InternalProtocolNegotiator.ServerFactory {
        private final InternalProtocolNegotiator.ServerFactory fallbackProtocolNegotiator;

        private ServerFactory(InternalProtocolNegotiator.ServerFactory fallbackNegotiator) {
            this.fallbackProtocolNegotiator = fallbackNegotiator;
        }

        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator(ObjectPool<? extends Executor> offloadExecutorPool) {
            return new ServerSecurityProtocolNegotiator((InternalProtocolNegotiator.ProtocolNegotiator)this.fallbackProtocolNegotiator.newNegotiator((ObjectPool)offloadExecutorPool));
        }
    }
}

