/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.grpc.Attributes;
import net.snowflake.client.jdbc.internal.grpc.EquivalentAddressGroup;
import net.snowflake.client.jdbc.internal.grpc.HttpConnectProxiedSocketAddress;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerRegistry;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.StatusOr;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.util.OutlierDetectionLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.AddressFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterImplLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterResolverLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.Endpoints;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.PriorityLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsAttributes;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsConfig;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsEndpointResource;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Locality;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsLogger;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.XdsInternalAttributes;

final class ClusterResolverLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancerRegistry lbRegistry;
    private final LoadBalancer delegate;
    private ClusterState clusterState;

    ClusterResolverLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.delegate = lbRegistry.getProvider("priority_experimental").newLoadBalancer(helper);
        this.lbRegistry = Preconditions.checkNotNull(lbRegistry, "lbRegistry");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cluster-resolver-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.delegate.handleNameResolutionError(error);
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        this.delegate.shutdown();
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        StatusOr<XdsEndpointResource.EdsUpdate> edsUpdate;
        StatusOr<ClusterResolutionResult> statusOrResult;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        XdsConfig xdsConfig = resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CONFIG);
        ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance = config.discoveryMechanism;
        String cluster = instance.cluster;
        if (this.clusterState == null) {
            this.clusterState = new ClusterState();
        }
        if (!(statusOrResult = this.clusterState.edsUpdateToResult(config, instance, edsUpdate = ClusterResolverLoadBalancer.getEdsUpdate(xdsConfig, cluster))).hasValue()) {
            Status status = Status.UNAVAILABLE.withDescription(statusOrResult.getStatus().getDescription()).withCause(statusOrResult.getStatus().getCause());
            this.delegate.handleNameResolutionError(status);
            return status;
        }
        ClusterResolutionResult result = statusOrResult.getValue();
        List addresses = result.addresses;
        if (addresses.isEmpty()) {
            Status status = Status.UNAVAILABLE.withDescription("No usable endpoint from cluster: " + cluster);
            this.delegate.handleNameResolutionError(status);
            return status;
        }
        PriorityLoadBalancerProvider.PriorityLbConfig childConfig = new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(result.priorityChildConfigs), Collections.unmodifiableList(result.priorities));
        return this.delegate.acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).setAddresses(Collections.unmodifiableList(addresses)).build());
    }

    private static StatusOr<XdsEndpointResource.EdsUpdate> getEdsUpdate(XdsConfig xdsConfig, String cluster) {
        StatusOr<XdsConfig.XdsClusterConfig> clusterConfig = xdsConfig.getClusters().get(cluster);
        if (clusterConfig == null) {
            return StatusOr.fromStatus(Status.INTERNAL.withDescription("BUG: cluster resolver could not find cluster in xdsConfig"));
        }
        if (!clusterConfig.hasValue()) {
            return StatusOr.fromStatus(clusterConfig.getStatus());
        }
        if (!(clusterConfig.getValue().getChildren() instanceof XdsConfig.XdsClusterConfig.EndpointConfig)) {
            return StatusOr.fromStatus(Status.INTERNAL.withDescription("BUG: cluster resolver cluster with children of unknown type"));
        }
        XdsConfig.XdsClusterConfig.EndpointConfig endpointConfig = (XdsConfig.XdsClusterConfig.EndpointConfig)clusterConfig.getValue().getChildren();
        return endpointConfig.getEndpoint();
    }

    private static Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> generatePriorityChildConfigs(ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism discovery, Object endpointLbConfig, LoadBalancerRegistry lbRegistry, Map<String, Map<Locality, Integer>> prioritizedLocalityWeights, List<Endpoints.DropOverload> dropOverloads) {
        HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
        for (String priority : prioritizedLocalityWeights.keySet()) {
            ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(discovery.cluster, discovery.edsServiceName, discovery.lrsServerInfo, discovery.maxConcurrentRequests, dropOverloads, endpointLbConfig, discovery.tlsContext, discovery.filterMetadata, discovery.backendMetricPropagation);
            LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
            Object priorityChildPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig(clusterImplLbProvider, clusterImplConfig);
            if (discovery.outlierDetection != null) {
                LoadBalancerProvider outlierDetectionProvider = lbRegistry.getProvider("outlier_detection_experimental");
                priorityChildPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig(outlierDetectionProvider, ClusterResolverLoadBalancer.buildOutlierDetectionLbConfig(discovery.outlierDetection, priorityChildPolicy));
            }
            boolean isEds = discovery.type == ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.Type.EDS;
            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(priorityChildPolicy, isEds);
            configs.put(priority, priorityChildConfig);
        }
        return configs;
    }

    private static OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig buildOutlierDetectionLbConfig(EnvoyServerProtoData.OutlierDetection outlierDetection, Object childConfig) {
        EnvoyServerProtoData.FailurePercentageEjection failurePercentage;
        EnvoyServerProtoData.SuccessRateEjection successRate;
        OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder configBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder();
        configBuilder.setChildConfig(childConfig);
        if (outlierDetection.intervalNanos() != null) {
            configBuilder.setIntervalNanos(outlierDetection.intervalNanos());
        }
        if (outlierDetection.baseEjectionTimeNanos() != null) {
            configBuilder.setBaseEjectionTimeNanos(outlierDetection.baseEjectionTimeNanos());
        }
        if (outlierDetection.maxEjectionTimeNanos() != null) {
            configBuilder.setMaxEjectionTimeNanos(outlierDetection.maxEjectionTimeNanos());
        }
        if (outlierDetection.maxEjectionPercent() != null) {
            configBuilder.setMaxEjectionPercent(outlierDetection.maxEjectionPercent());
        }
        if ((successRate = outlierDetection.successRateEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder successRateConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder();
            if (successRate.stdevFactor() != null) {
                successRateConfigBuilder.setStdevFactor(successRate.stdevFactor());
            }
            if (successRate.enforcementPercentage() != null) {
                successRateConfigBuilder.setEnforcementPercentage(successRate.enforcementPercentage());
            }
            if (successRate.minimumHosts() != null) {
                successRateConfigBuilder.setMinimumHosts(successRate.minimumHosts());
            }
            if (successRate.requestVolume() != null) {
                successRateConfigBuilder.setRequestVolume(successRate.requestVolume());
            }
            configBuilder.setSuccessRateEjection(successRateConfigBuilder.build());
        }
        if ((failurePercentage = outlierDetection.failurePercentageEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder failurePercentageConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder();
            if (failurePercentage.threshold() != null) {
                failurePercentageConfigBuilder.setThreshold(failurePercentage.threshold());
            }
            if (failurePercentage.enforcementPercentage() != null) {
                failurePercentageConfigBuilder.setEnforcementPercentage(failurePercentage.enforcementPercentage());
            }
            if (failurePercentage.minimumHosts() != null) {
                failurePercentageConfigBuilder.setMinimumHosts(failurePercentage.minimumHosts());
            }
            if (failurePercentage.requestVolume() != null) {
                failurePercentageConfigBuilder.setRequestVolume(failurePercentage.requestVolume());
            }
            configBuilder.setFailurePercentageEjection(failurePercentageConfigBuilder.build());
        }
        return configBuilder.build();
    }

    private static String priorityName(String cluster, int priority) {
        return cluster + "[child" + priority + "]";
    }

    private static String localityName(Locality locality) {
        return "{region=\"" + locality.region() + "\", zone=\"" + locality.zone() + "\", sub_zone=\"" + locality.subZone() + "\"}";
    }

    private static class ClusterResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs;
        private final List<String> priorities;

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs, List<String> priorities) {
            this.addresses = addresses;
            this.priorityChildConfigs = configs;
            this.priorities = priorities;
        }
    }

    private final class ClusterState {
        private Map<Locality, String> localityPriorityNames = Collections.emptyMap();
        int priorityNameGenId = 1;

        private ClusterState() {
        }

        StatusOr<ClusterResolutionResult> edsUpdateToResult(ClusterResolverLoadBalancerProvider.ClusterResolverConfig config, ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism discovery, StatusOr<XdsEndpointResource.EdsUpdate> updateOr) {
            if (!updateOr.hasValue()) {
                return StatusOr.fromStatus(updateOr.getStatus());
            }
            XdsEndpointResource.EdsUpdate update = updateOr.getValue();
            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update {0}", update);
            if (ClusterResolverLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0}: {1} localities, {2} drop categories", discovery.cluster, update.localityLbEndpointsMap.size(), update.dropPolicies.size());
            }
            Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints = update.localityLbEndpointsMap;
            List<Endpoints.DropOverload> dropOverloads = update.dropPolicies;
            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
            HashMap prioritizedLocalityWeights = new HashMap();
            List<String> sortedPriorityNames = this.generatePriorityNames(discovery.cluster, localityLbEndpoints);
            for (Locality locality : localityLbEndpoints.keySet()) {
                Endpoints.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                String priorityName = this.localityPriorityNames.get(locality);
                boolean discard = true;
                for (Endpoints.LbEndpoint endpoint : localityLbInfo.endpoints()) {
                    EquivalentAddressGroup eag;
                    if (!endpoint.isHealthy()) continue;
                    discard = false;
                    long weight = localityLbInfo.localityWeight();
                    if (endpoint.loadBalancingWeight() != 0) {
                        weight *= (long)endpoint.loadBalancingWeight();
                    }
                    String localityName = ClusterResolverLoadBalancer.localityName(locality);
                    Attributes attr = endpoint.eag().getAttributes().toBuilder().set(XdsAttributes.ATTR_LOCALITY, locality).set(EquivalentAddressGroup.ATTR_LOCALITY_NAME, localityName).set(XdsAttributes.ATTR_LOCALITY_WEIGHT, localityLbInfo.localityWeight()).set(XdsAttributes.ATTR_SERVER_WEIGHT, weight).set(XdsInternalAttributes.ATTR_ADDRESS_NAME, endpoint.hostname()).build();
                    if (config.isHttp11ProxyAvailable()) {
                        ArrayList<SocketAddress> rewrittenAddresses = new ArrayList<SocketAddress>();
                        for (SocketAddress addr : endpoint.eag().getAddresses()) {
                            rewrittenAddresses.add(this.rewriteAddress(addr, endpoint.endpointMetadata(), localityLbInfo.localityMetadata()));
                        }
                        eag = new EquivalentAddressGroup(rewrittenAddresses, attr);
                    } else {
                        eag = new EquivalentAddressGroup(endpoint.eag().getAddresses(), attr);
                    }
                    eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, localityName));
                    addresses.add(eag);
                }
                if (discard) {
                    ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints", locality);
                    continue;
                }
                if (!prioritizedLocalityWeights.containsKey(priorityName)) {
                    prioritizedLocalityWeights.put(priorityName, new HashMap());
                }
                ((Map)prioritizedLocalityWeights.get(priorityName)).put(locality, localityLbInfo.localityWeight());
            }
            if (prioritizedLocalityWeights.isEmpty()) {
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0} has no usable priority/locality/endpoint", discovery.cluster);
            }
            sortedPriorityNames.retainAll(prioritizedLocalityWeights.keySet());
            Map priorityChildConfigs = ClusterResolverLoadBalancer.generatePriorityChildConfigs(discovery, config.lbConfig, ClusterResolverLoadBalancer.this.lbRegistry, prioritizedLocalityWeights, dropOverloads);
            return StatusOr.fromValue(new ClusterResolutionResult(addresses, priorityChildConfigs, sortedPriorityNames));
        }

        private SocketAddress rewriteAddress(SocketAddress addr, ImmutableMap<String, Object> endpointMetadata, ImmutableMap<String, Object> localityMetadata) {
            SocketAddress proxyAddress;
            if (!(addr instanceof InetSocketAddress)) {
                return addr;
            }
            try {
                proxyAddress = (SocketAddress)endpointMetadata.get("envoy.http11_proxy_transport_socket.proxy_address");
                if (proxyAddress == null) {
                    proxyAddress = (SocketAddress)localityMetadata.get("envoy.http11_proxy_transport_socket.proxy_address");
                }
            }
            catch (ClassCastException e) {
                return addr;
            }
            if (proxyAddress == null) {
                return addr;
            }
            return HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress((InetSocketAddress)addr).setProxyAddress(proxyAddress).build();
        }

        private List<String> generatePriorityNames(String name, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints) {
            TreeMap todo = new TreeMap();
            for (Locality locality : localityLbEndpoints.keySet()) {
                int priority = localityLbEndpoints.get(locality).priority();
                if (!todo.containsKey(priority)) {
                    todo.put(priority, new ArrayList());
                }
                ((List)todo.get(priority)).add(locality);
            }
            HashMap<Locality, String> newNames = new HashMap<Locality, String>();
            HashSet<String> usedNames = new HashSet<String>();
            ArrayList<String> ret = new ArrayList<String>();
            for (Integer priority : todo.keySet()) {
                String foundName = "";
                for (Locality locality : (List)todo.get(priority)) {
                    if (!this.localityPriorityNames.containsKey(locality) || !usedNames.add(this.localityPriorityNames.get(locality))) continue;
                    foundName = this.localityPriorityNames.get(locality);
                    break;
                }
                if ("".equals(foundName)) {
                    foundName = ClusterResolverLoadBalancer.priorityName(name, this.priorityNameGenId++);
                }
                for (Locality locality : (List)todo.get(priority)) {
                    newNames.put(locality, foundName);
                }
                ret.add(foundName);
            }
            this.localityPriorityNames = newNames;
            return ret;
        }
    }
}

