/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.protobuf.Struct;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterImplLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.Endpoints;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.client.BackendMetricPropagation;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public final class ClusterImplLoadBalancerProvider
extends LoadBalancerProvider {
    public static final CallOptions.Key<Consumer<Map<String, Struct>>> FILTER_METADATA_CONSUMER = CallOptions.Key.createWithDefault("net.snowflake.client.jdbc.internal.grpc.xds.internalFilterMetadataConsumer", m4 -> {});

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cluster_impl_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterImplLoadBalancer(helper);
    }

    static final class ClusterImplConfig {
        final String cluster;
        @Nullable
        final String edsServiceName;
        @Nullable
        final Bootstrapper.ServerInfo lrsServerInfo;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final List<Endpoints.DropOverload> dropCategories;
        final Object childConfig;
        final Map<String, Struct> filterMetadata;
        @Nullable
        final BackendMetricPropagation backendMetricPropagation;

        ClusterImplConfig(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, List<Endpoints.DropOverload> dropCategories, Object childConfig, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, Map<String, Struct> filterMetadata, @Nullable BackendMetricPropagation backendMetricPropagation) {
            this.cluster = Preconditions.checkNotNull(cluster, "cluster");
            this.edsServiceName = edsServiceName;
            this.lrsServerInfo = lrsServerInfo;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.filterMetadata = ImmutableMap.copyOf(filterMetadata);
            this.dropCategories = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(dropCategories, "dropCategories")));
            this.childConfig = Preconditions.checkNotNull(childConfig, "childConfig");
            this.backendMetricPropagation = backendMetricPropagation;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("cluster", this.cluster).add("edsServiceName", this.edsServiceName).add("lrsServerInfo", this.lrsServerInfo).add("maxConcurrentRequests", this.maxConcurrentRequests).add("dropCategories", this.dropCategories).add("childConfig", this.childConfig).toString();
        }
    }
}

