/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.stub;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Predicate;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.StatusException;
import net.snowflake.client.jdbc.internal.grpc.stub.ClientCalls;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10918")
public final class BlockingClientCall<ReqT, RespT> {
    private static final Logger logger = Logger.getLogger(BlockingClientCall.class.getName());
    private final BlockingQueue<RespT> buffer;
    private final ClientCall<ReqT, RespT> call;
    private final ClientCalls.ThreadSafeThreadlessExecutor executor;
    private boolean writeClosed;
    private AtomicReference<CloseState> closeState = new AtomicReference();

    BlockingClientCall(ClientCall<ReqT, RespT> call, ClientCalls.ThreadSafeThreadlessExecutor executor) {
        this.call = call;
        this.executor = executor;
        this.buffer = new ArrayBlockingQueue<RespT>(1);
    }

    public RespT read() throws InterruptedException, StatusException {
        try {
            return this.read(true, 0L);
        }
        catch (TimeoutException e) {
            throw new AssertionError("should never happen", e);
        }
    }

    public RespT read(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        long endNanoTime = System.nanoTime() + unit.toNanos(timeout);
        return this.read(false, endNanoTime);
    }

    private RespT read(boolean waitForever, long endNanoTime) throws InterruptedException, TimeoutException, StatusException {
        Predicate predicate = BlockingClientCall::skipWaitingForRead;
        this.executor.waitAndDrainWithTimeout(waitForever, endNanoTime, predicate, this);
        Object bufferedValue = this.buffer.poll();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Client Blocking read had value:  " + bufferedValue);
        }
        if (bufferedValue != null) {
            this.call.request(1);
            return (RespT)bufferedValue;
        }
        CloseState currentCloseState = this.closeState.get();
        if (currentCloseState == null) {
            throw new IllegalStateException("The message disappeared... are you reading from multiple threads?");
        }
        if (!currentCloseState.status.isOk()) {
            throw currentCloseState.status.asException(currentCloseState.trailers);
        }
        return null;
    }

    boolean skipWaitingForRead() {
        return this.closeState.get() != null || !this.buffer.isEmpty();
    }

    public boolean hasNext() throws InterruptedException, StatusException {
        this.executor.waitAndDrain(x -> !x.buffer.isEmpty() || x.closeState.get() != null, this);
        CloseState currentCloseState = this.closeState.get();
        if (currentCloseState != null && !currentCloseState.status.isOk()) {
            throw currentCloseState.status.asException(currentCloseState.trailers);
        }
        return !this.buffer.isEmpty();
    }

    public boolean write(ReqT request) throws InterruptedException, StatusException {
        try {
            return this.write(true, request, 0L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean write(ReqT request, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        long endNanoTime = System.nanoTime() + unit.toNanos(timeout);
        return this.write(false, request, endNanoTime);
    }

    private boolean write(boolean waitForever, ReqT request, long endNanoTime) throws InterruptedException, TimeoutException, StatusException {
        if (this.writeClosed) {
            throw new IllegalStateException("Writes cannot be done after calling halfClose or cancel");
        }
        Predicate predicate = x -> x.call.isReady() || x.closeState.get() != null;
        this.executor.waitAndDrainWithTimeout(waitForever, endNanoTime, predicate, this);
        CloseState savedCloseState = this.closeState.get();
        if (savedCloseState == null) {
            this.call.sendMessage(request);
            return true;
        }
        if (savedCloseState.status.isOk()) {
            return false;
        }
        throw savedCloseState.status.asException(savedCloseState.trailers);
    }

    void sendSingleRequest(ReqT request) {
        this.call.sendMessage(request);
    }

    public void cancel(String message, Throwable cause) {
        this.writeClosed = true;
        this.call.cancel(message, cause);
    }

    public void halfClose() {
        if (this.writeClosed) {
            throw new IllegalStateException("halfClose cannot be called after already half closed or cancelled");
        }
        this.writeClosed = true;
        this.call.halfClose();
    }

    @VisibleForTesting
    Status getClosedStatus() {
        this.executor.drain();
        CloseState state = this.closeState.get();
        return state == null ? null : state.status;
    }

    @VisibleForTesting
    boolean isEitherReadOrWriteReady() {
        return this.isWriteLegal() && this.isWriteReady() || this.isReadReady();
    }

    @VisibleForTesting
    boolean isReadReady() {
        this.executor.drain();
        return !this.buffer.isEmpty();
    }

    @VisibleForTesting
    boolean isWriteReady() {
        this.executor.drain();
        return this.isWriteLegal() && this.call.isReady();
    }

    private boolean isWriteLegal() {
        return !this.writeClosed && this.closeState.get() == null;
    }

    ClientCall.Listener<RespT> getListener() {
        return new QueuingListener();
    }

    private static final class CloseState {
        final Status status;
        final Metadata trailers;

        CloseState(Status status, Metadata trailers) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.trailers = trailers;
        }
    }

    private final class QueuingListener
    extends ClientCall.Listener<RespT> {
        private QueuingListener() {
        }

        @Override
        public void onMessage(RespT value) {
            Preconditions.checkState(BlockingClientCall.this.closeState.get() == null, "ClientCall already closed");
            BlockingClientCall.this.buffer.add(value);
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            CloseState newCloseState = new CloseState(status, trailers);
            boolean wasSet = BlockingClientCall.this.closeState.compareAndSet(null, newCloseState);
            Preconditions.checkState(wasSet, "ClientCall already closed");
        }
    }
}

