/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.opentelemetry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Stopwatch;
import net.snowflake.client.jdbc.internal.google.common.base.Supplier;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.InternalConfigurator;
import net.snowflake.client.jdbc.internal.grpc.InternalConfiguratorRegistry;
import net.snowflake.client.jdbc.internal.grpc.InternalManagedChannelBuilder;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannelBuilder;
import net.snowflake.client.jdbc.internal.grpc.MetricSink;
import net.snowflake.client.jdbc.internal.grpc.ServerBuilder;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.OpenTelemetryMetricSink;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.OpenTelemetryMetricsModule;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.OpenTelemetryMetricsResource;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.OpenTelemetryPlugin;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.OpenTelemetryTracingModule;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.internal.OpenTelemetryConstants;
import net.snowflake.client.jdbc.internal.opentelemetry.api.OpenTelemetry;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.Meter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.MeterProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Tracer;

public final class GrpcOpenTelemetry {
    private static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = new Supplier<Stopwatch>(){

        @Override
        public Stopwatch get() {
            return Stopwatch.createUnstarted();
        }
    };
    @VisibleForTesting
    static boolean ENABLE_OTEL_TRACING = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_ENABLE_OTEL_TRACING", false);
    private final OpenTelemetry openTelemetrySdk;
    private final MeterProvider meterProvider;
    private final Meter meter;
    private final Map<String, Boolean> enableMetrics;
    private final boolean disableDefault;
    private final OpenTelemetryMetricsResource resource;
    private final OpenTelemetryMetricsModule openTelemetryMetricsModule;
    private final OpenTelemetryTracingModule openTelemetryTracingModule;
    private final List<String> optionalLabels;
    private final MetricSink sink;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GrpcOpenTelemetry(Builder builder) {
        this.openTelemetrySdk = Preconditions.checkNotNull(builder.openTelemetrySdk, "openTelemetrySdk");
        this.meterProvider = Preconditions.checkNotNull(this.openTelemetrySdk.getMeterProvider(), "meterProvider");
        this.meter = this.meterProvider.meterBuilder("net.snowflake.client.jdbc.internal.grpc-java").setInstrumentationVersion("1.77.0").build();
        this.enableMetrics = ImmutableMap.copyOf(builder.enableMetrics);
        this.disableDefault = builder.disableAll;
        this.resource = GrpcOpenTelemetry.createMetricInstruments(this.meter, this.enableMetrics, this.disableDefault);
        this.optionalLabels = ImmutableList.copyOf(builder.optionalLabels);
        this.openTelemetryMetricsModule = new OpenTelemetryMetricsModule(STOPWATCH_SUPPLIER, this.resource, this.optionalLabels, builder.plugins);
        this.openTelemetryTracingModule = new OpenTelemetryTracingModule(this.openTelemetrySdk);
        this.sink = new OpenTelemetryMetricSink(this.meter, this.enableMetrics, this.disableDefault, this.optionalLabels);
    }

    @VisibleForTesting
    OpenTelemetry getOpenTelemetryInstance() {
        return this.openTelemetrySdk;
    }

    @VisibleForTesting
    MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    @VisibleForTesting
    Meter getMeter() {
        return this.meter;
    }

    @VisibleForTesting
    OpenTelemetryMetricsResource getResource() {
        return this.resource;
    }

    @VisibleForTesting
    Map<String, Boolean> getEnableMetrics() {
        return this.enableMetrics;
    }

    @VisibleForTesting
    List<String> getOptionalLabels() {
        return this.optionalLabels;
    }

    MetricSink getSink() {
        return this.sink;
    }

    @VisibleForTesting
    Tracer getTracer() {
        return this.openTelemetryTracingModule.getTracer();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10591")
    public void registerGlobal() {
        InternalConfiguratorRegistry.setConfigurators(Collections.singletonList(new InternalConfigurator(){

            @Override
            public void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
                GrpcOpenTelemetry.this.configureChannelBuilder(channelBuilder);
            }

            @Override
            public void configureServerBuilder(ServerBuilder<?> serverBuilder) {
                GrpcOpenTelemetry.this.configureServerBuilder(serverBuilder);
            }
        }));
    }

    public void configureChannelBuilder(ManagedChannelBuilder<?> builder) {
        InternalManagedChannelBuilder.addMetricSink(builder, this.sink);
        InternalManagedChannelBuilder.interceptWithTarget(builder, this.openTelemetryMetricsModule::getClientInterceptor);
        if (ENABLE_OTEL_TRACING) {
            builder.intercept(this.openTelemetryTracingModule.getClientInterceptor());
        }
    }

    public void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        if (ENABLE_OTEL_TRACING) {
            serverBuilder.addStreamTracerFactory(this.openTelemetryTracingModule.getServerTracerFactory());
            serverBuilder.intercept(this.openTelemetryTracingModule.getServerSpanPropagationInterceptor());
        }
        serverBuilder.addStreamTracerFactory(this.openTelemetryMetricsModule.getServerTracerFactory());
    }

    @VisibleForTesting
    static OpenTelemetryMetricsResource createMetricInstruments(Meter meter, Map<String, Boolean> enableMetrics, boolean disableDefault) {
        OpenTelemetryMetricsResource.Builder builder = OpenTelemetryMetricsResource.builder();
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.call.duration", enableMetrics, disableDefault)) {
            builder.clientCallDurationCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.call.duration").setUnit("s").setDescription("Time taken by gRPC to complete an RPC from application's perspective").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.attempt.started", enableMetrics, disableDefault)) {
            builder.clientAttemptCountCounter(meter.counterBuilder("net.snowflake.client.jdbc.internal.grpc.client.attempt.started").setUnit("{attempt}").setDescription("Number of client call attempts started").build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.attempt.duration", enableMetrics, disableDefault)) {
            builder.clientAttemptDurationCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.attempt.duration").setUnit("s").setDescription("Time taken to complete a client call attempt").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.attempt.sent_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.clientTotalSentCompressedMessageSizeCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.attempt.sent_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes sent per client call attempt").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.attempt.rcvd_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.clientTotalReceivedCompressedMessageSizeCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.attempt.rcvd_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes received per call attempt").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.call.retries", enableMetrics, disableDefault)) {
            builder.clientCallRetriesCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.call.retries").setUnit("{retry}").setDescription("Number of retries during the client call. If there were no retries, 0 is not reported.").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.RETRY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.call.transparent_retries", enableMetrics, disableDefault)) {
            builder.clientCallTransparentRetriesCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.call.transparent_retries").setUnit("{transparent_retry}").setDescription("Number of transparent retries during the client call. If there were no transparent retries, 0 is not reported.").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.TRANSPARENT_RETRY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.call.hedges", enableMetrics, disableDefault)) {
            builder.clientCallHedgesCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.call.hedges").setUnit("{hedge}").setDescription("Number of hedges during the client call. If there were no hedges, 0 is not reported.").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.HEDGE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.client.call.retry_delay", enableMetrics, disableDefault)) {
            builder.clientCallRetryDelayCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.client.call.retry_delay").setUnit("s").setDescription("Total time of delay while there is no active attempt during the client call").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.server.call.started", enableMetrics, disableDefault)) {
            builder.serverCallCountCounter(meter.counterBuilder("net.snowflake.client.jdbc.internal.grpc.server.call.started").setUnit("{call}").setDescription("Number of server calls started").build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.server.call.duration", enableMetrics, disableDefault)) {
            builder.serverCallDurationCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.server.call.duration").setUnit("s").setDescription("Time taken to complete a call from server transport's perspective").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.server.call.sent_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.serverTotalSentCompressedMessageSizeCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.server.call.sent_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes sent per server call").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("net.snowflake.client.jdbc.internal.grpc.server.call.rcvd_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.serverTotalReceivedCompressedMessageSizeCounter(meter.histogramBuilder("net.snowflake.client.jdbc.internal.grpc.server.call.rcvd_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes received per server call").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        return builder.build();
    }

    static boolean isMetricEnabled(String metricName, Map<String, Boolean> enableMetrics, boolean disableDefault) {
        Boolean explicitlyEnabled = enableMetrics.get(metricName);
        if (explicitlyEnabled != null) {
            return explicitlyEnabled;
        }
        return OpenTelemetryMetricsModule.DEFAULT_PER_CALL_METRICS_SET.contains(metricName) && !disableDefault;
    }

    public static class Builder {
        private OpenTelemetry openTelemetrySdk = OpenTelemetry.noop();
        private final List<OpenTelemetryPlugin> plugins = new ArrayList<OpenTelemetryPlugin>();
        private final Collection<String> optionalLabels = new ArrayList<String>();
        private final Map<String, Boolean> enableMetrics = new HashMap<String, Boolean>();
        private boolean disableAll;

        private Builder() {
        }

        public Builder sdk(OpenTelemetry sdk) {
            this.openTelemetrySdk = sdk;
            return this;
        }

        Builder plugin(OpenTelemetryPlugin plugin) {
            this.plugins.add(Preconditions.checkNotNull(plugin, "plugin"));
            return this;
        }

        public Builder addOptionalLabel(String optionalLabelKey) {
            this.optionalLabels.add(optionalLabelKey);
            return this;
        }

        public Builder enableMetrics(Collection<String> enableMetrics) {
            for (String metric : enableMetrics) {
                this.enableMetrics.put(metric, true);
            }
            return this;
        }

        public Builder disableMetrics(Collection<String> disableMetrics) {
            for (String metric : disableMetrics) {
                this.enableMetrics.put(metric, false);
            }
            return this;
        }

        public Builder disableAllMetrics() {
            this.enableMetrics.clear();
            this.disableAll = true;
            return this;
        }

        Builder enableTracing(boolean enable) {
            ENABLE_OTEL_TRACING = enable;
            return this;
        }

        public GrpcOpenTelemetry build() {
            return new GrpcOpenTelemetry(this);
        }
    }
}

