/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.googleapis;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.common.io.CharStreams;
import net.snowflake.client.jdbc.internal.google.errorprone.annotations.concurrent.GuardedBy;
import net.snowflake.client.jdbc.internal.grpc.MetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.NameResolverRegistry;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.alts.InternalCheckGcpEnvironment;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.internal.SharedResourceHolder;
import net.snowflake.client.jdbc.internal.grpc.xds.InternalGrpcBootstrapperImpl;
import net.snowflake.client.jdbc.internal.grpc.xds.InternalSharedXdsClientPoolProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsNameResolverProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsClient;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsInitializationException;

final class GoogleCloudToProdNameResolver
extends NameResolver {
    private static final Logger logger = Logger.getLogger(GoogleCloudToProdNameResolver.class.getName());
    @VisibleForTesting
    static final String METADATA_URL_ZONE = "http://metadata.google.internal/computeMetadata/v1/instance/zone";
    @VisibleForTesting
    static final String METADATA_URL_SUPPORT_IPV6 = "http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ipv6s";
    static final String C2P_AUTHORITY = "traffic-director-c2p.xds.googleapis.com";
    @VisibleForTesting
    static boolean isOnGcp = InternalCheckGcpEnvironment.isOnGcp();
    private static final String serverUriOverride = System.getenv("GRPC_TEST_ONLY_GOOGLE_C2P_RESOLVER_TRAFFIC_DIRECTOR_URI");
    @GuardedBy(value="GoogleCloudToProdNameResolver.class")
    private static Bootstrapper.BootstrapInfo bootstrapInfo;
    private static HttpConnectionProvider httpConnectionProvider;
    private static int c2pId;
    private final String authority;
    private final SynchronizationContext syncContext;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final String target;
    private final MetricRecorder metricRecorder;
    private final NameResolver delegate;
    private final boolean usingExecutorResource;
    private final String schemeOverride = !isOnGcp ? "dns" : "xds";
    private InternalSharedXdsClientPoolProvider.XdsClientResult xdsClientPool;
    private XdsClient xdsClient;
    private Executor executor;
    private NameResolver.Listener2 listener;
    private boolean succeeded;
    private boolean resolving;
    private boolean shutdown;

    private static synchronized Bootstrapper.BootstrapInfo getBootstrapInfo() throws XdsInitializationException, IOException {
        if (bootstrapInfo != null) {
            return bootstrapInfo;
        }
        Bootstrapper.BootstrapInfo bootstrapInfoTmp = InternalGrpcBootstrapperImpl.parseBootstrap(GoogleCloudToProdNameResolver.generateBootstrap());
        if (httpConnectionProvider == HttpConnectionFactory.INSTANCE) {
            bootstrapInfo = bootstrapInfoTmp;
        }
        return bootstrapInfoTmp;
    }

    GoogleCloudToProdNameResolver(URI targetUri, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource) {
        this(targetUri, args, executorResource, NameResolverRegistry.getDefaultRegistry().asFactory());
    }

    @VisibleForTesting
    GoogleCloudToProdNameResolver(URI targetUri, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource, NameResolver.Factory nameResolverFactory) {
        this.executorResource = Preconditions.checkNotNull(executorResource, "executorResource");
        String targetPath = Preconditions.checkNotNull(Preconditions.checkNotNull(targetUri, "targetUri").getPath(), "targetPath");
        Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
        this.authority = GrpcUtil.checkAuthority(targetPath.substring(1));
        this.syncContext = Preconditions.checkNotNull(args, "args").getSynchronizationContext();
        targetUri = GoogleCloudToProdNameResolver.overrideUriScheme(targetUri, this.schemeOverride);
        if (this.schemeOverride.equals("xds")) {
            targetUri = GoogleCloudToProdNameResolver.overrideUriAuthority(targetUri, C2P_AUTHORITY);
            args = args.toBuilder().setArg(XdsNameResolverProvider.XDS_CLIENT_SUPPLIER, () -> this.xdsClient).build();
        }
        this.target = targetUri.toString();
        this.metricRecorder = args.getMetricRecorder();
        this.delegate = Preconditions.checkNotNull(nameResolverFactory, "nameResolverFactory").newNameResolver(targetUri, args);
        this.executor = args.getOffloadExecutor();
        this.usingExecutorResource = this.executor == null;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public void start(NameResolver.Listener2 listener) {
        if (this.delegate == null) {
            listener.onError(Status.INTERNAL.withDescription("Delegate resolver not found, scheme: " + this.schemeOverride));
            return;
        }
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    private void resolve() {
        if (this.resolving || this.shutdown || this.delegate == null) {
            return;
        }
        this.resolving = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "start with schemaOverride = {0}", this.schemeOverride);
        }
        if (this.schemeOverride.equals("dns")) {
            this.delegate.start(this.listener);
            this.succeeded = true;
            this.resolving = false;
            return;
        }
        if (this.executor == null) {
            this.executor = SharedResourceHolder.get(this.executorResource);
        }
        class Resolve
        implements Runnable {
            Resolve() {
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
        this.executor.execute(new Resolve());
    }

    @VisibleForTesting
    static ImmutableMap<String, ?> generateBootstrap() throws IOException {
        return GoogleCloudToProdNameResolver.generateBootstrap(GoogleCloudToProdNameResolver.queryZoneMetadata(METADATA_URL_ZONE), GoogleCloudToProdNameResolver.queryIpv6SupportMetadata(METADATA_URL_SUPPORT_IPV6));
    }

    private static ImmutableMap<String, ?> generateBootstrap(String zone, boolean supportIpv6) {
        ImmutableMap.Builder<String, Object> nodeBuilder = ImmutableMap.builder();
        nodeBuilder.put("id", "C2P-" + (c2pId & Integer.MAX_VALUE));
        if (!zone.isEmpty()) {
            nodeBuilder.put("locality", ImmutableMap.of("zone", zone));
        }
        if (supportIpv6) {
            nodeBuilder.put("metadata", ImmutableMap.of("TRAFFICDIRECTOR_DIRECTPATH_C2P_IPV6_CAPABLE", true));
        }
        ImmutableMap.Builder<String, Object> serverBuilder = ImmutableMap.builder();
        String serverUri = "directpath-pa.googleapis.com";
        if (serverUriOverride != null && serverUriOverride.length() > 0) {
            serverUri = serverUriOverride;
        }
        serverBuilder.put("server_uri", serverUri);
        serverBuilder.put("channel_creds", ImmutableList.of(ImmutableMap.of("type", "google_default")));
        serverBuilder.put("server_features", ImmutableList.of("xds_v3", "ignore_resource_deletion"));
        ImmutableMap.Builder authoritiesBuilder = ImmutableMap.builder();
        authoritiesBuilder.put(C2P_AUTHORITY, ImmutableMap.of("xds_servers", ImmutableList.of(serverBuilder.buildOrThrow())));
        return ImmutableMap.of("node", nodeBuilder.buildOrThrow(), "xds_servers", ImmutableList.of(serverBuilder.buildOrThrow()), "authorities", authoritiesBuilder.buildOrThrow());
    }

    @Override
    public void refresh() {
        if (this.succeeded) {
            this.delegate.refresh();
        } else if (!this.resolving) {
            this.resolve();
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.delegate != null) {
            this.delegate.shutdown();
        }
        if (this.xdsClient != null) {
            this.xdsClient = this.xdsClientPool.returnObject(this.xdsClient);
        }
        if (this.executor != null && this.usingExecutorResource) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryZoneMetadata(String url) throws IOException {
        String respBody;
        HttpURLConnection con = null;
        try {
            con = httpConnectionProvider.createConnection(url);
            if (con.getResponseCode() != 200) {
                String string = "";
                return string;
            }
            try (InputStreamReader reader = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);){
                respBody = CharStreams.toString(reader);
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        int index = respBody.lastIndexOf(47);
        return index == -1 ? "" : respBody.substring(index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean queryIpv6SupportMetadata(String url) throws IOException {
        HttpURLConnection con = null;
        try {
            int c;
            con = httpConnectionProvider.createConnection(url);
            if (con.getResponseCode() != 200) {
                boolean bl = false;
                return bl;
            }
            InputStream inputStream = con.getInputStream();
            boolean bl = inputStream != null && (c = inputStream.read()) != -1 && !Character.isWhitespace(c);
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @VisibleForTesting
    static void setHttpConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        GoogleCloudToProdNameResolver.httpConnectionProvider = httpConnectionProvider == null ? HttpConnectionFactory.INSTANCE : httpConnectionProvider;
    }

    @VisibleForTesting
    static void setC2pId(int c2pId) {
        GoogleCloudToProdNameResolver.c2pId = c2pId;
    }

    private static URI overrideUriScheme(URI uri, String scheme) {
        URI res;
        try {
            res = new URI(scheme, uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid scheme: " + scheme, ex);
        }
        return res;
    }

    private static URI overrideUriAuthority(URI uri, String authority) {
        URI res;
        try {
            res = new URI(uri.getScheme(), authority, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid authority: " + authority, ex);
        }
        return res;
    }

    static /* synthetic */ Bootstrapper.BootstrapInfo access$000() throws XdsInitializationException, IOException {
        return GoogleCloudToProdNameResolver.getBootstrapInfo();
    }

    static /* synthetic */ SynchronizationContext access$1000(GoogleCloudToProdNameResolver x0) {
        return x0.syncContext;
    }

    static {
        httpConnectionProvider = HttpConnectionFactory.INSTANCE;
        c2pId = new Random().nextInt();
    }

    @VisibleForTesting
    static interface HttpConnectionProvider {
        public HttpURLConnection createConnection(String var1) throws IOException;
    }

    private static enum HttpConnectionFactory implements HttpConnectionProvider
    {
        INSTANCE;


        @Override
        public HttpURLConnection createConnection(String url) throws IOException {
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(10000);
            con.setRequestProperty("Metadata-Flavor", "Google");
            return con;
        }
    }
}

