/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.CallbackMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.DoubleCounterMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.DoubleHistogramMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LongCounterMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.LongGaugeMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.LongHistogramMetricInstrument;
import net.snowflake.client.jdbc.internal.grpc.LongUpDownCounterMetricInstrument;

@Internal
public interface MetricRecorder {
    default public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongUpDownCounter(LongUpDownCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public Registration registerBatchCallback(BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        return () -> {};
    }

    public static interface Registration
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface BatchRecorder {
        default public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
            Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
        }
    }

    public static interface BatchCallback {
        public void accept(BatchRecorder var1);
    }
}

