/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Identifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public final class LeafEntityTypeConstraint {
    public static final LeafEntityTypeConstraint ANY = new LeafEntityTypeConstraint(null);
    private final Set<EntityType> allowed;

    public LeafEntityTypeConstraint(Set<EntityType> allowed) {
        this.allowed = CollectionUtils.isNotEmpty(allowed) ? allowed : null;
    }

    public boolean allowsAny() {
        return CollectionUtils.isEmpty(this.allowed);
    }

    public Set<EntityType> getAllowed() {
        return this.allowed;
    }

    public List<String> getAllowedAsStringList() {
        if (this.allowsAny()) {
            return null;
        }
        return Identifier.toStringList(this.allowed);
    }

    public boolean isAllowed(EntityType type) {
        return this.allowsAny() || this.allowed.contains(type);
    }

    public String toString() {
        if (this.allowsAny()) {
            return "null";
        }
        return this.allowed.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeafEntityTypeConstraint)) {
            return false;
        }
        LeafEntityTypeConstraint that = (LeafEntityTypeConstraint)o;
        return Objects.equals(this.getAllowed(), that.getAllowed());
    }

    public int hashCode() {
        return Objects.hash(this.getAllowed());
    }

    public static LeafEntityTypeConstraint parse(List<String> values) throws ParseException {
        if (CollectionUtils.isEmpty(values)) {
            return ANY;
        }
        HashSet<EntityType> types = new HashSet<EntityType>();
        for (String v : values) {
            types.add(new EntityType(v));
        }
        return new LeafEntityTypeConstraint(types);
    }
}

