/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.URIUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class EntityListingRequest
extends FederationAPIRequest {
    private final EntityType entityType;

    public EntityListingRequest(URI endpoint) {
        this(endpoint, null);
    }

    public EntityListingRequest(URI endpoint, EntityType entityType) {
        super(endpoint);
        this.entityType = entityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.entityType != null) {
            params.put("entity_type", Collections.singletonList(this.entityType.getValue()));
        }
        return Collections.unmodifiableMap(params);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        httpRequest.appendQueryParameters(this.toParameters());
        return httpRequest;
    }

    public static EntityListingRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.GET);
        EntityType entityType = null;
        Map<String, List<String>> params = httpRequest.getQueryStringParameters();
        String value = MultivaluedMapUtils.getFirstValue(params, "entity_type");
        if (StringUtils.isNotBlank(value)) {
            entityType = new EntityType(value);
        }
        return new EntityListingRequest(URIUtils.getBaseURI(httpRequest.getURI()), entityType);
    }
}

