/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth;

import java.net.URI;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionFactory;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Audience;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Issuer;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.URLUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public final class PrivateKeyJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet<JWSAlgorithm> supported = new HashSet<JWSAlgorithm>();
        supported.addAll(JWSAlgorithm.Family.RSA);
        supported.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(supported);
    }

    public PrivateKeyJWT(ClientID clientID, URI endpoint, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(endpoint.toString())), jwsAlgorithm, privateKey, keyID, null, null, jcaProvider);
    }

    public PrivateKeyJWT(Issuer iss, ClientID clientID, URI endpoint, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(iss, clientID, new Audience(endpoint.toString())), jwsAlgorithm, privateKey, keyID, null, null, jcaProvider);
    }

    public PrivateKeyJWT(ClientID clientID, URI endpoint, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, List<Base64> x5c, Base64URL x5t256, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(endpoint.toString())), jwsAlgorithm, privateKey, keyID, x5c, x5t256, jcaProvider);
    }

    public PrivateKeyJWT(Issuer iss, ClientID clientID, URI endpoint, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, List<Base64> x5c, Base64URL x5t256, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(iss, clientID, new Audience(endpoint.toString())), jwsAlgorithm, privateKey, keyID, x5c, x5t256, jcaProvider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(jwtAuthClaimsSet, jwsAlgorithm, privateKey, keyID, null, null, jcaProvider);
    }

    public PrivateKeyJWT(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, List<Base64> x5c, Base64URL x5t256, Provider jcaProvider) throws JOSEException {
        this(JWTAssertionFactory.create(jwtAuthClaimsSet, jwsAlgorithm, privateKey, keyID, x5c, x5t256, jcaProvider));
    }

    @Deprecated
    public PrivateKeyJWT(ClientID clientID, URI endpoint, JWSAlgorithm jwsAlgorithm, RSAPrivateKey rsaPrivateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(endpoint.toString())), jwsAlgorithm, rsaPrivateKey, keyID, jcaProvider);
    }

    @Deprecated
    public PrivateKeyJWT(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, RSAPrivateKey rsaPrivateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(JWTAssertionFactory.create(jwtAuthClaimsSet, jwsAlgorithm, rsaPrivateKey, keyID, null, null, jcaProvider));
    }

    @Deprecated
    public PrivateKeyJWT(ClientID clientID, URI endpoint, JWSAlgorithm jwsAlgorithm, ECPrivateKey ecPrivateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(new JWTAuthenticationClaimsSet(clientID, new Audience(endpoint.toString())), jwsAlgorithm, ecPrivateKey, keyID, jcaProvider);
    }

    @Deprecated
    public PrivateKeyJWT(JWTAuthenticationClaimsSet jwtAuthClaimsSet, JWSAlgorithm jwsAlgorithm, ECPrivateKey ecPrivateKey, String keyID, Provider jcaProvider) throws JOSEException {
        this(JWTAssertionFactory.create(jwtAuthClaimsSet, jwsAlgorithm, ecPrivateKey, keyID, null, null, jcaProvider));
    }

    public PrivateKeyJWT(SignedJWT clientAssertion) {
        super(ClientAuthenticationMethod.PRIVATE_KEY_JWT, clientAssertion);
        JWSAlgorithm alg = clientAssertion.getHeader().getAlgorithm();
        if (!JWSAlgorithm.Family.RSA.contains(alg) && !JWSAlgorithm.Family.EC.contains(alg)) {
            throw new IllegalArgumentException("The client assertion JWT must be RSA or ECDSA-signed (RS256, RS384, RS512, PS256, PS384, PS512, ES256, ES384 or ES512)");
        }
    }

    public static PrivateKeyJWT parse(Map<String, List<String>> params) throws ParseException {
        PrivateKeyJWT privateKeyJWT;
        JWTAuthentication.ensureClientAssertionType(params);
        SignedJWT clientAssertion = JWTAuthentication.parseClientAssertion(params);
        try {
            privateKeyJWT = new PrivateKeyJWT(clientAssertion);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
        ClientID clientID = JWTAuthentication.parseClientID(params);
        if (clientID != null && !clientID.equals(privateKeyJWT.getClientID())) {
            throw new ParseException("Invalid private key JWT authentication: The client identifier doesn't match the client assertion subject");
        }
        return privateKeyJWT;
    }

    public static PrivateKeyJWT parse(String paramsString) throws ParseException {
        Map<String, List<String>> params = URLUtils.parseParameters(paramsString);
        return PrivateKeyJWT.parse(params);
    }

    public static PrivateKeyJWT parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        return PrivateKeyJWT.parse(httpRequest.getBodyAsFormParameters());
    }
}

