/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.event.ProgressEventType;
import net.snowflake.client.jdbc.internal.amazonaws.event.ProgressListenerChain;
import net.snowflake.client.jdbc.internal.amazonaws.event.SDKProgressPublisher;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PutObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.PauseResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.PauseStatus;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.PersistableUpload;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.Transfer;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.TransferManager;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.CompleteMultipartUpload;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.TransferMonitor;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.UploadCallable;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.UploadImpl;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.future.CompletedFuture;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.future.DelegatingFuture;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.future.FailedFuture;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.model.UploadResult;

public class UploadMonitor
implements Callable<Void>,
TransferMonitor {
    private final AmazonS3 s3;
    private final PutObjectRequest origReq;
    private final ProgressListenerChain listener;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private final ExecutorService threadPool;
    private final DelegatingFuture<UploadResult> resultFuture = new DelegatingFuture();
    private final DelegatingFuture<Void> initiateUploadFuture = new DelegatingFuture();

    public Future<UploadResult> getFuture() {
        return this.resultFuture;
    }

    @Override
    public synchronized boolean isDone() {
        return this.resultFuture.isDone();
    }

    public static UploadMonitor create(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        UploadMonitor uploadMonitor = new UploadMonitor(manager, transfer, threadPool, multipartUploadCallable, putObjectRequest, progressListenerChain);
        uploadMonitor.initiateUploadFuture.setDelegate(threadPool.submit(uploadMonitor));
        return uploadMonitor;
    }

    private UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.multipartUploadCallable = multipartUploadCallable;
        this.origReq = putObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = transfer;
        this.threadPool = threadPool;
    }

    @Override
    public Void call() {
        try {
            UploadResult result = this.multipartUploadCallable.call();
            if (result == null) {
                CompleteMultipartUpload completeTask = new CompleteMultipartUpload(this.multipartUploadCallable.getMultipartUploadId(), this.s3, this.origReq, this.multipartUploadCallable.getFutures(), this.multipartUploadCallable.getETags(), this.listener, this, this.multipartUploadCallable.getExpectedPartCount());
                this.resultFuture.setDelegate(this.threadPool.submit(completeTask));
            } else {
                this.setTransferStateToCompleted();
                this.resultFuture.setDelegate(new CompletedFuture<UploadResult>(result));
            }
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            SdkClientException exception = new SdkClientException("Upload canceled");
            this.resultFuture.setDelegate(new FailedFuture(exception));
        }
        catch (Throwable e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.resultFuture.setDelegate(new FailedFuture(e));
        }
        return null;
    }

    void setTransferStateToCompleted() {
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    void setTransferStateToFailed() {
        this.transfer.setState(Transfer.TransferState.Failed);
    }

    PauseResult<PersistableUpload> pause(boolean forceCancel) {
        PersistableUpload persistableUpload = this.multipartUploadCallable.getPersistableUpload();
        if (persistableUpload == null) {
            PauseStatus pauseStatus = TransferManagerUtils.determinePauseStatus(this.transfer.getState(), forceCancel);
            if (forceCancel) {
                this.cancelTransferFutures();
                this.multipartUploadCallable.safelyAbortMultipartUpload(this.initiateUploadFuture);
            }
            return new PauseResult<PersistableUpload>(pauseStatus);
        }
        this.initiateUploadFuture.cancel(true);
        this.cancelTransferFutures();
        return new PauseResult<PersistableUpload>(PauseStatus.SUCCESS, persistableUpload);
    }

    private void cancelTransferFutures() {
        this.resultFuture.cancel(true);
        this.multipartUploadCallable.getFutures().cancel(true);
    }

    void performAbort() {
        this.cancelTransferFutures();
        this.multipartUploadCallable.safelyAbortMultipartUpload(this.initiateUploadFuture);
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
    }
}

