/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.internal.core.minicore;

import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.internal.core.minicore.LibcDetector;
import net.snowflake.client.jdbc.SnowflakeUtil;

@SnowflakeJdbcInternalApi
public class MinicorePlatform {
    private final Constants.OS os;
    private final Constants.Architecture architecture;
    private final String osName = SnowflakeUtil.systemGetProperty("os.name");
    private final String osArch = SnowflakeUtil.systemGetProperty("os.arch");
    private final String resourcePath;
    private final boolean supported;

    public MinicorePlatform() {
        this.os = Constants.getOS();
        this.architecture = Constants.getArchitecture();
        this.resourcePath = this.buildResourcePath();
        this.supported = this.resourcePath != null && MinicorePlatform.class.getResource(this.resourcePath) != null;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public String getLibraryPath() {
        if (!this.supported) {
            throw new UnsupportedOperationException(String.format("Minicore library not available for platform: OS=%s (%s), Arch=%s (%s)", new Object[]{this.os, this.osName, this.architecture, this.osArch}));
        }
        return this.resourcePath;
    }

    private String buildResourcePath() {
        String fileName = this.getLibraryFileName();
        if (fileName == null) {
            return null;
        }
        return "/minicore/" + fileName;
    }

    public String getPlatformIdentifier() {
        String osId = this.getOsIdentifier();
        if (osId == null || this.architecture == Constants.Architecture.UNKNOWN) {
            return null;
        }
        String archId = this.architecture.getIdentifier();
        LibcDetector.LibcVariant libcVariant = LibcDetector.detectLibcVariant();
        if (libcVariant != LibcDetector.LibcVariant.UNSUPPORTED) {
            return osId + "-" + archId + "-" + libcVariant.getIdentifier();
        }
        return osId + "-" + archId;
    }

    private String getOsIdentifier() {
        if (this.os == null) {
            return null;
        }
        switch (this.os) {
            case LINUX: {
                if (Constants.isAix()) {
                    return "aix";
                }
                return "linux";
            }
            case MAC: {
                return "macos";
            }
            case WINDOWS: {
                return "windows";
            }
        }
        return null;
    }

    private String getLibraryExtension() {
        if (this.os == null) {
            return "";
        }
        if (Constants.isAix()) {
            return ".so";
        }
        switch (this.os) {
            case WINDOWS: {
                return ".dll";
            }
            case MAC: {
                return ".dylib";
            }
        }
        return ".so";
    }

    public String getLibraryFileName() {
        String osId = this.getOsIdentifier();
        if (osId == null || this.architecture == Constants.Architecture.UNKNOWN) {
            return null;
        }
        String archId = this.architecture.getIdentifier();
        StringBuilder fileName = new StringBuilder();
        fileName.append("libsf_mini_core");
        fileName.append("_").append(osId);
        fileName.append("_").append(archId);
        LibcDetector.LibcVariant libcVariant = LibcDetector.detectLibcVariant();
        if (libcVariant != LibcDetector.LibcVariant.UNSUPPORTED) {
            fileName.append("_").append(libcVariant.getIdentifier());
        }
        fileName.append(this.getLibraryExtension());
        return fileName.toString();
    }

    public Constants.OS getOs() {
        return this.os;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String toString() {
        return String.format("MinicorePlatform{os=%s, arch=%s, osName='%s', osArch='%s', supported=%s}", new Object[]{this.os, this.architecture, this.osName, this.osArch, this.isSupported()});
    }
}

