/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.HttpHeadersCustomizer;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.RequestHandler2;
import net.snowflake.client.jdbc.internal.apache.http.Header;
import net.snowflake.client.jdbc.internal.apache.http.HttpException;
import net.snowflake.client.jdbc.internal.apache.http.HttpRequest;
import net.snowflake.client.jdbc.internal.apache.http.HttpRequestInterceptor;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class HeaderCustomizerHttpRequestInterceptor
extends RequestHandler2
implements HttpRequestInterceptor {
    private static final SFLogger logger = SFLoggerFactory.getLogger(HeaderCustomizerHttpRequestInterceptor.class);
    private final List<HttpHeadersCustomizer> headersCustomizers;

    public HeaderCustomizerHttpRequestInterceptor(List<HttpHeadersCustomizer> headersCustomizers) {
        this.headersCustomizers = headersCustomizers != null ? new ArrayList<HttpHeadersCustomizer>(headersCustomizers) : new ArrayList<HttpHeadersCustomizer>();
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        if (this.headersCustomizers.isEmpty()) {
            return;
        }
        String httpMethod = httpRequest.getRequestLine().getMethod();
        String uri = httpRequest.getRequestLine().getUri();
        Map<String, List<String>> currentHeaders = HeaderCustomizerHttpRequestInterceptor.extractHeaders(httpRequest);
        Set<String> protectedHeaders = currentHeaders.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        Integer executionCount = (Integer)httpContext.getAttribute("net.snowflake.client.core.execution-count");
        boolean isRetry = executionCount == null || executionCount > 0;
        for (HttpHeadersCustomizer customizer : this.headersCustomizers) {
            if (!customizer.applies(httpMethod, uri, currentHeaders)) continue;
            if (customizer.invokeOnce() && isRetry) {
                logger.debug("Customizer {} should only run on the first attempt and this is a {} retry. Skipping.", customizer.getClass().getCanonicalName(), executionCount);
                continue;
            }
            Map<String, List<String>> newHeaders = customizer.newHeaders();
            logger.debug("Customizer {} is adding headers {}", customizer.getClass().getCanonicalName(), newHeaders.keySet());
            for (Map.Entry<String, List<String>> entry : newHeaders.entrySet()) {
                if (HeaderCustomizerHttpRequestInterceptor.isTryingToOverrideDriverHeader(entry, protectedHeaders)) {
                    logger.debug("Customizer {} attempted to override existing driver header {} which is not allowed. Skipping.", customizer.getClass().getCanonicalName(), entry.getKey());
                    continue;
                }
                for (String value : entry.getValue()) {
                    httpRequest.addHeader(entry.getKey(), value);
                }
            }
        }
    }

    @Override
    public void beforeRequest(Request<?> request) {
        super.beforeRequest(request);
        if (this.headersCustomizers.isEmpty()) {
            return;
        }
        String httpMethod = request.getHttpMethod().name();
        String uri = request.getEndpoint().toString();
        Map<String, List<String>> currentHeaders = HeaderCustomizerHttpRequestInterceptor.extractHeaders(request);
        Set<String> protectedHeaders = currentHeaders.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        for (HttpHeadersCustomizer customizer : this.headersCustomizers) {
            if (!customizer.applies(httpMethod, uri, currentHeaders)) continue;
            Map<String, List<String>> newHeaders = customizer.newHeaders();
            logger.debug("Customizer {} is adding headers {}", customizer.getClass().getCanonicalName(), newHeaders.keySet());
            for (Map.Entry<String, List<String>> entry : newHeaders.entrySet()) {
                if (HeaderCustomizerHttpRequestInterceptor.isTryingToOverrideDriverHeader(entry, protectedHeaders)) {
                    logger.debug("Customizer {} attempted to override existing driver header {} which is not allowed. Skipping.", customizer.getClass().getCanonicalName(), entry.getKey());
                    continue;
                }
                for (String value : entry.getValue()) {
                    request.addHeader(entry.getKey(), value);
                }
            }
        }
    }

    private static boolean isTryingToOverrideDriverHeader(Map.Entry<String, List<String>> entry, Set<String> protectedHeaders) {
        return protectedHeaders.contains(entry.getKey().toLowerCase());
    }

    private static Map<String, List<String>> extractHeaders(HttpRequest request) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        for (Header header : request.getAllHeaders()) {
            headerMap.computeIfAbsent(header.getName(), k -> new ArrayList()).add(header.getValue());
        }
        return headerMap;
    }

    private static Map<String, List<String>> extractHeaders(Request<?> request) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            headerMap.computeIfAbsent(entry.getKey(), k -> new ArrayList()).add(entry.getValue());
        }
        return headerMap;
    }
}

