/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSqlInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeUtil;

@SnowflakeJdbcInternalApi
public abstract class BaseSqlInput
implements SFSqlInput {
    protected final SFBaseSession session;
    protected final Converters converters;
    protected final List<FieldMetadata> fields;

    protected BaseSqlInput(SFBaseSession session, Converters converters, List<FieldMetadata> fields) {
        this.session = session;
        this.converters = converters;
        this.fields = fields;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return this.readTimestamp(null);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readCharacterStream");
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readAsciiStream");
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readBinaryStream");
    }

    @Override
    public Ref readRef() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readRef");
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readBlob");
    }

    @Override
    public Clob readClob() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readClob");
    }

    @Override
    public Array readArray() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readArray");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public URL readURL() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readCharacterStream");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readNClob");
    }

    @Override
    public String readNString() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readNString");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readSQLXML");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session, "readRowId");
    }

    abstract Map<String, Object> convertSqlInputToMap(SQLInput var1);

    protected String convertString(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStringConverter().getString(value, columnType, columnSubType, scale));
    }

    protected Boolean convertBoolean(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getBooleanConverter().getBoolean(value, columnType));
    }

    protected Short convertShort(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getShort(value, columnType));
    }

    protected Integer convertInt(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getInt(value, columnType));
    }

    protected Long convertLong(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getLong(value, columnType));
    }

    protected Float convertFloat(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> Float.valueOf(this.converters.getNumberConverter().getFloat(value, columnType)));
    }

    protected Double convertDouble(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getDouble(value, columnType));
    }

    protected BigDecimal convertBigDecimal(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getBigDecimal(value, columnType));
    }

    protected byte[] convertBytes(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getBytesConverter().getBytes(value, columnType, columnSubType, scale));
    }
}

