/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;

abstract class FixedSizeExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ReservoirCell[] storage;
    private final ReservoirCellSelector reservoirCellSelector;
    private final BiFunction<ReservoirCell, Attributes, T> mapAndResetCell;
    private volatile boolean hasMeasurements = false;

    FixedSizeExemplarReservoir(Clock clock, int size, ReservoirCellSelector reservoirCellSelector, BiFunction<ReservoirCell, Attributes, T> mapAndResetCell) {
        this.storage = new ReservoirCell[size];
        for (int i = 0; i < size; ++i) {
            this.storage[i] = new ReservoirCell(clock);
        }
        this.reservoirCellSelector = reservoirCellSelector;
        this.mapAndResetCell = mapAndResetCell;
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        int bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context);
        if (bucket != -1) {
            this.storage[bucket].recordLongMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        int bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context);
        if (bucket != -1) {
            this.storage[bucket].recordDoubleMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        if (!this.hasMeasurements) {
            return Collections.emptyList();
        }
        ArrayList<ExemplarData> results = new ArrayList<ExemplarData>();
        for (ReservoirCell reservoirCell : this.storage) {
            ExemplarData result = (ExemplarData)this.mapAndResetCell.apply(reservoirCell, pointAttributes);
            if (result == null) continue;
            results.add(result);
        }
        this.reservoirCellSelector.reset();
        this.hasMeasurements = false;
        return Collections.unmodifiableList(results);
    }
}

