/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.CommonTlsContextUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertProviderClientSslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public final class CertProviderClientSslContextProviderFactory {
    private static final CertProviderClientSslContextProviderFactory DEFAULT_INSTANCE = new CertProviderClientSslContextProviderFactory(CertificateProviderStore.getInstance());
    private final CertificateProviderStore certificateProviderStore;

    @VisibleForTesting
    public CertProviderClientSslContextProviderFactory(CertificateProviderStore certificateProviderStore) {
        this.certificateProviderStore = certificateProviderStore;
    }

    public static CertProviderClientSslContextProviderFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    public SslContextProvider getProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
        Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
        CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
        CertificateValidationContext staticCertValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance rootCertInstance = CertProviderSslContextProvider.getRootCertProviderInstance(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance certInstance = CertProviderSslContextProvider.getCertProviderInstance(commonTlsContext);
        if (CommonTlsContextUtil.hasCertProviderInstance(upstreamTlsContext.getCommonTlsContext()) || CommonTlsContextUtil.isUsingSystemRootCerts(upstreamTlsContext.getCommonTlsContext())) {
            return new CertProviderClientSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, upstreamTlsContext, this.certificateProviderStore);
        }
        throw new UnsupportedOperationException("Unsupported configurations in UpstreamTlsContext!");
    }
}

