/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.DetectedPlatform;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.GCPPlatformDetector;

final class GoogleKubernetesEngine
implements DetectedPlatform {
    private final GCPMetadataConfig metadataConfig;
    private final Map<String, String> availableAttributes;

    GoogleKubernetesEngine(GCPMetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
        this.availableAttributes = this.prepareAttributes();
    }

    private Map<String, String> prepareAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gke_cluster_name", this.metadataConfig.getClusterName());
        map.put("gke_cluster_location", this.metadataConfig.getClusterLocation());
        map.put("gke_cluster_location_type", this.getClusterLocationType());
        map.put("instance_id", this.metadataConfig.getInstanceId());
        return Collections.unmodifiableMap(map);
    }

    private String getClusterLocationType() {
        long dashCount;
        String clusterLocation = this.metadataConfig.getClusterLocation();
        long l = dashCount = clusterLocation == null || clusterLocation.isEmpty() ? 0L : clusterLocation.chars().filter(ch -> ch == 45).count();
        if (dashCount == 1L) {
            return "REGION";
        }
        if (dashCount == 2L) {
            return "ZONE";
        }
        return "";
    }

    @Override
    public GCPPlatformDetector.SupportedPlatform getSupportedPlatform() {
        return GCPPlatformDetector.SupportedPlatform.GOOGLE_KUBERNETES_ENGINE;
    }

    @Override
    public String getProjectId() {
        return this.metadataConfig.getProjectId();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.availableAttributes;
    }
}

