/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.batching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFunction;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.core.ObsoleteApi;
import net.snowflake.client.jdbc.internal.google.api.core.SettableApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.BatchMerger;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.BatchingFlowController;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.BatchingThreshold;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.FlowController;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.ThresholdBatchReceiver;
import net.snowflake.client.jdbc.internal.google.api.gax.util.TimeConversionUtils;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.threeten.bp.Duration;

public final class ThresholdBatcher<E> {
    private final Runnable pushCurrentBatchRunnable = new Runnable(){

        @Override
        public void run() {
            ThresholdBatcher.this.pushCurrentBatch();
        }
    };
    private final ArrayList<BatchingThreshold<E>> thresholds;
    private final ScheduledExecutorService executor;
    private final java.time.Duration maxDelay;
    private final ThresholdBatchReceiver<E> receiver;
    private final BatchingFlowController<E> flowController;
    private final BatchMerger<E> batchMerger;
    private final ReentrantLock lock = new ReentrantLock();
    private E currentOpenBatch;
    private Future<?> currentAlarmFuture;

    private ThresholdBatcher(Builder<E> builder) {
        this.thresholds = new ArrayList(((Builder)builder).thresholds);
        this.executor = Preconditions.checkNotNull(((Builder)builder).executor);
        this.maxDelay = Preconditions.checkNotNull(((Builder)builder).maxDelay);
        this.receiver = Preconditions.checkNotNull(((Builder)builder).receiver);
        this.flowController = Preconditions.checkNotNull(((Builder)builder).flowController);
        this.batchMerger = Preconditions.checkNotNull(((Builder)builder).batchMerger);
        this.resetThresholds();
    }

    public static <E> Builder<E> newBuilder() {
        return new Builder();
    }

    public void add(E e) throws FlowController.FlowControlException {
        this.flowController.reserve(e);
        this.lock.lock();
        try {
            this.receiver.validateBatch(e);
            boolean anyThresholdReached = this.isAnyThresholdReached(e);
            if (this.currentOpenBatch == null) {
                this.currentOpenBatch = e;
                if (!anyThresholdReached) {
                    this.currentAlarmFuture = this.executor.schedule(this.pushCurrentBatchRunnable, this.maxDelay.toMillis(), TimeUnit.MILLISECONDS);
                }
            } else {
                this.batchMerger.merge(this.currentOpenBatch, e);
            }
            if (anyThresholdReached) {
                this.pushCurrentBatch();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.currentOpenBatch == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public ApiFuture<Void> pushCurrentBatch() {
        final E batch = this.removeBatch();
        if (batch == null) {
            return ApiFutures.immediateFuture(null);
        }
        final SettableApiFuture<Void> retFuture = SettableApiFuture.create();
        ApiFutures.addCallback(this.receiver.processBatch(batch), new ApiFutureCallback<Object>(){

            @Override
            public void onSuccess(Object obj) {
                ThresholdBatcher.this.flowController.release(batch);
                retFuture.set(null);
            }

            @Override
            public void onFailure(Throwable t2) {
                ThresholdBatcher.this.flowController.release(batch);
                retFuture.setException(t2);
            }
        }, MoreExecutors.directExecutor());
        return retFuture;
    }

    private E removeBatch() {
        this.lock.lock();
        try {
            E batch = this.currentOpenBatch;
            this.currentOpenBatch = null;
            if (this.currentAlarmFuture != null) {
                this.currentAlarmFuture.cancel(false);
                this.currentAlarmFuture = null;
            }
            this.resetThresholds();
            E e = batch;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isAnyThresholdReached(E e) {
        for (BatchingThreshold<E> threshold : this.thresholds) {
            threshold.accumulate(e);
            if (!threshold.isThresholdReached()) continue;
            return true;
        }
        return false;
    }

    private void resetThresholds() {
        for (int i = 0; i < this.thresholds.size(); ++i) {
            this.thresholds.set(i, this.thresholds.get(i).copyWithZeroedValue());
        }
    }

    public static class Builder<E> {
        private Collection<BatchingThreshold<E>> thresholds;
        private ScheduledExecutorService executor;
        private java.time.Duration maxDelay;
        private ThresholdBatchReceiver<E> receiver;
        private BatchingFlowController<E> flowController;
        private BatchMerger<E> batchMerger;

        private Builder() {
        }

        public Builder<E> setExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder<E> setMaxDelayDuration(java.time.Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        @ObsoleteApi(value="Use setMaxDelayDuration(java.time.Duration) instead")
        public Builder<E> setMaxDelay(Duration maxDelay) {
            return this.setMaxDelayDuration(TimeConversionUtils.toJavaTimeDuration(maxDelay));
        }

        public Builder<E> setThresholds(Collection<BatchingThreshold<E>> thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public Builder<E> setReceiver(ThresholdBatchReceiver<E> receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder<E> setFlowController(BatchingFlowController<E> flowController) {
            this.flowController = flowController;
            return this;
        }

        public Builder<E> setBatchMerger(BatchMerger<E> batchMerger) {
            this.batchMerger = batchMerger;
            return this;
        }

        public ThresholdBatcher<E> build() {
            return new ThresholdBatcher(this);
        }
    }

    private class ReleaseResourcesFunction<T>
    implements ApiFunction<T, Void> {
        private final E batch;

        private ReleaseResourcesFunction(E batch) {
            this.batch = batch;
        }

        @Override
        public Void apply(T input) {
            ThresholdBatcher.this.flowController.release(this.batch);
            return null;
        }
    }
}

