/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators;

import java.net.URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEObjectType;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.source.ImmutableSecret;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.source.JWKSource;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.BadJOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JWEKeySelector;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JWSKeySelector;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.SecurityContext;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.ResourceRetriever;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.EncryptedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.PlainJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.BadJWTException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.GeneralException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.Secret;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Issuer;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators.AbstractJWTValidator;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators.LogoutTokenClaimsVerifier;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LogoutTokenValidator
extends AbstractJWTValidator {
    public static final JOSEObjectType TYPE = new JOSEObjectType("logout+jwt");
    private final boolean requireTypedTokens;

    public LogoutTokenValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, JWKSet jwkSet) {
        this(expectedIssuer, clientID, new JWSVerificationKeySelector(expectedJWSAlg, new ImmutableJWKSet(jwkSet)), null);
    }

    public LogoutTokenValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, URL jwkSetURI) {
        this(expectedIssuer, clientID, expectedJWSAlg, jwkSetURI, null);
    }

    public LogoutTokenValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, URL jwkSetURI, ResourceRetriever resourceRetriever) {
        this(expectedIssuer, clientID, new JWSVerificationKeySelector(expectedJWSAlg, new RemoteJWKSet(jwkSetURI, resourceRetriever)), null);
    }

    public LogoutTokenValidator(Issuer expectedIssuer, ClientID clientID, JWSAlgorithm expectedJWSAlg, Secret clientSecret) {
        this(expectedIssuer, clientID, new JWSVerificationKeySelector(expectedJWSAlg, new ImmutableSecret(clientSecret.getValueBytes())), null);
    }

    @Deprecated
    public LogoutTokenValidator(Issuer expectedIssuer, ClientID clientID, JWSKeySelector<?> jwsKeySelector, JWEKeySelector<?> jweKeySelector) {
        this(expectedIssuer, clientID, false, jwsKeySelector, jweKeySelector);
    }

    public LogoutTokenValidator(Issuer expectedIssuer, ClientID clientID, boolean requireTypedToken, JWSKeySelector<?> jwsKeySelector, JWEKeySelector<?> jweKeySelector) {
        super(TYPE, expectedIssuer, clientID, jwsKeySelector, jweKeySelector);
        this.requireTypedTokens = requireTypedToken;
    }

    public LogoutTokenClaimsSet validate(JWT logoutToken) throws BadJOSEException, JOSEException {
        if (logoutToken instanceof PlainJWT) {
            throw new BadJWTException("Unsecured (plain) logout tokens are illegal");
        }
        if (logoutToken instanceof SignedJWT) {
            return this.validate((SignedJWT)logoutToken);
        }
        if (logoutToken instanceof EncryptedJWT) {
            return this.validate((EncryptedJWT)logoutToken);
        }
        throw new JOSEException("Unexpected JWT type: " + logoutToken.getClass());
    }

    private LogoutTokenClaimsSet validate(SignedJWT logoutToken) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSTypeVerifier(new TypeVerifier(this.requireTypedTokens));
        jwtProcessor.setJWSKeySelector(this.getJWSKeySelector());
        jwtProcessor.setJWTClaimsSetVerifier(new LogoutTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID()));
        JWTClaimsSet jwtClaimsSet = jwtProcessor.process(logoutToken, null);
        return LogoutTokenValidator.toLogoutTokenClaimsSet(jwtClaimsSet);
    }

    private LogoutTokenClaimsSet validate(EncryptedJWT logoutToken) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJWTException("Decryption of JWTs not configured");
        }
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWETypeVerifier(new TypeVerifier(this.requireTypedTokens));
        jwtProcessor.setJWSKeySelector(this.getJWSKeySelector());
        jwtProcessor.setJWEKeySelector(this.getJWEKeySelector());
        jwtProcessor.setJWTClaimsSetVerifier(new LogoutTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID()));
        JWTClaimsSet jwtClaimsSet = jwtProcessor.process(logoutToken, null);
        return LogoutTokenValidator.toLogoutTokenClaimsSet(jwtClaimsSet);
    }

    private static LogoutTokenClaimsSet toLogoutTokenClaimsSet(JWTClaimsSet jwtClaimsSet) throws JOSEException {
        try {
            return new LogoutTokenClaimsSet(jwtClaimsSet);
        }
        catch (ParseException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static LogoutTokenValidator create(OIDCProviderMetadata opMetadata, OIDCClientInformation clientInfo, JWKSource<?> clientJWKSource) throws GeneralException {
        JWSKeySelector jwsKeySelector = IDTokenValidator.createJWSKeySelector(opMetadata, clientInfo);
        JWEKeySelector jweKeySelector = IDTokenValidator.createJWEKeySelector(opMetadata, clientInfo, clientJWKSource);
        return new LogoutTokenValidator(opMetadata.getIssuer(), clientInfo.getID(), jwsKeySelector, jweKeySelector);
    }

    private static class TypeVerifier
    implements JOSEObjectTypeVerifier {
        private final boolean requireTypedTokens;

        public TypeVerifier(boolean requireTypedTokens) {
            this.requireTypedTokens = requireTypedTokens;
        }

        public void verify(JOSEObjectType type, SecurityContext context) throws BadJOSEException {
            if (this.requireTypedTokens) {
                if (!TYPE.equals(type)) {
                    throw new BadJOSEException("Invalid / missing logout token typ (type) header, must be " + TYPE);
                }
            } else if (type != null && !TYPE.equals(type) && !JOSEObjectType.JWT.equals(type)) {
                throw new BadJOSEException("If set the logout token typ (type) header must be " + TYPE + " or " + JOSEObjectType.JWT);
            }
        }
    }
}

