/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AccessTokenResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public class OIDCTokenResponse
extends AccessTokenResponse {
    private final OIDCTokens tokens;

    public OIDCTokenResponse(OIDCTokens tokens) {
        this(tokens, null);
    }

    public OIDCTokenResponse(OIDCTokens tokens, Map<String, Object> customParams) {
        super(tokens, customParams);
        this.tokens = tokens;
    }

    public OIDCTokens getOIDCTokens() {
        return this.tokens;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.putAll(this.getOIDCTokens().toJSONObject());
        return o;
    }

    @Override
    public OIDCTokenResponse toSuccessResponse() {
        return this;
    }

    public static OIDCTokenResponse parse(JSONObject jsonObject) throws ParseException {
        OIDCTokens tokens = OIDCTokens.parse(jsonObject);
        HashMap<String, Object> customParams = new HashMap<String, Object>(jsonObject);
        for (String tokenParam : tokens.getParameterNames()) {
            customParams.remove(tokenParam);
        }
        if (customParams.isEmpty()) {
            return new OIDCTokenResponse(tokens);
        }
        return new OIDCTokenResponse(tokens, customParams);
    }

    public static OIDCTokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getBodyAsJSONObject();
        return OIDCTokenResponse.parse(jsonObject);
    }
}

