/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.model;

import java.io.Serializable;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.TargetObjectKeyFormat;

public class BucketLoggingConfiguration
implements Serializable {
    private String destinationBucketName = null;
    private String logFilePrefix = null;
    private TargetObjectKeyFormat targetObjectKeyFormat = null;

    public BucketLoggingConfiguration() {
    }

    public BucketLoggingConfiguration(String destinationBucketName, String logFilePrefix) {
        this.setLogFilePrefix(logFilePrefix);
        this.setDestinationBucketName(destinationBucketName);
    }

    public boolean isLoggingEnabled() {
        return this.destinationBucketName != null && this.logFilePrefix != null;
    }

    public String getLogFilePrefix() {
        return this.logFilePrefix;
    }

    public void setLogFilePrefix(String logFilePrefix) {
        if (logFilePrefix == null) {
            logFilePrefix = "";
        }
        this.logFilePrefix = logFilePrefix;
    }

    public String getDestinationBucketName() {
        return this.destinationBucketName;
    }

    public void setDestinationBucketName(String destinationBucketName) {
        this.destinationBucketName = destinationBucketName;
    }

    public TargetObjectKeyFormat getTargetObjectKeyFormat() {
        return this.targetObjectKeyFormat;
    }

    public void setTargetObjectKeyFormat(TargetObjectKeyFormat targetObjectKeyFormat) {
        this.targetObjectKeyFormat = targetObjectKeyFormat;
    }

    public BucketLoggingConfiguration withTargetObjectKeyFormat(TargetObjectKeyFormat targetObjectKeyFormat) {
        this.setTargetObjectKeyFormat(targetObjectKeyFormat);
        return this;
    }

    public String toString() {
        String result = "LoggingConfiguration enabled=" + this.isLoggingEnabled();
        if (this.isLoggingEnabled()) {
            result = result + ", destinationBucketName=" + this.getDestinationBucketName() + ", logFilePrefix=" + this.getLogFilePrefix();
        }
        if (this.targetObjectKeyFormat != null) {
            result = result + ", targetObjectKeyFormat=" + this.getTargetObjectKeyFormat();
        }
        return result;
    }
}

