/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.OperationInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.EmptyBodyRpcV2CborMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.MarshallerRegistry;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.RpcV2CborMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.RpcV2CborMarshallerContext;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.SimpleTypeRpcV2CborMarshallers;
import net.snowflake.client.jdbc.internal.amazonaws.util.BinaryUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.UriResourcePathUtils;

@SdkInternalApi
public class RpcV2CborProtocolMarshaller<OrigRequest>
implements ProtocolRequestMarshaller<OrigRequest> {
    private static final MarshallerRegistry DEFAULT_MARSHALLER_REGISTRY = RpcV2CborProtocolMarshaller.createDefaultMarshallerRegistry();
    private final StructuredRpcV2CborGenerator rpcv2cborGenerator;
    private final Request<OrigRequest> request;
    private final String contentType;
    private final boolean hasExplicitPayloadMember;
    private final RpcV2CborMarshallerContext marshallerContext;
    private final MarshallerRegistry marshallerRegistry;
    private final boolean isAwsQueryCompatible;

    public RpcV2CborProtocolMarshaller(StructuredRpcV2CborGenerator rpcv2cborGenerator, String contentType, OperationInfo operationInfo, OrigRequest originalRequest, MarshallerRegistry.Builder marshallerRegistryOverrides, EmptyBodyRpcV2CborMarshaller emptyBodyMarshaller, boolean isAwsQueryCompatible) {
        this.rpcv2cborGenerator = rpcv2cborGenerator;
        this.contentType = contentType;
        this.hasExplicitPayloadMember = operationInfo.hasExplicitPayloadMember();
        this.isAwsQueryCompatible = isAwsQueryCompatible;
        this.request = this.fillBasicRequestParams(operationInfo, originalRequest);
        this.marshallerRegistry = DEFAULT_MARSHALLER_REGISTRY.merge(marshallerRegistryOverrides);
        this.marshallerContext = RpcV2CborMarshallerContext.builder().rpcv2cborGenerator(rpcv2cborGenerator).marshallerRegistry(this.marshallerRegistry).protocolHandler(this).request(this.request).emptyBodyRpcV2CborMarshaller(emptyBodyMarshaller).build();
    }

    private Request<OrigRequest> fillBasicRequestParams(OperationInfo operationInfo, OrigRequest originalRequest) {
        DefaultRequest<OrigRequest> request = this.createRequest(operationInfo, originalRequest);
        request.setHttpMethod(operationInfo.httpMethodName());
        request.setResourcePath(UriResourcePathUtils.addStaticQueryParamtersToRequest(request, operationInfo.requestUri()));
        request.addHeader("smithy-protocol", "rpc-v2-cbor");
        request.addHeader("Accept", "application/cbor");
        return request;
    }

    private DefaultRequest<OrigRequest> createRequest(OperationInfo operationInfo, OrigRequest originalRequest) {
        if (originalRequest instanceof AmazonWebServiceRequest) {
            return new DefaultRequest((AmazonWebServiceRequest)originalRequest, operationInfo.serviceName());
        }
        return new DefaultRequest(operationInfo.serviceName());
    }

    private static MarshallerRegistry createDefaultMarshallerRegistry() {
        return MarshallerRegistry.builder().payloadMarshaller(MarshallingType.STRING, SimpleTypeRpcV2CborMarshallers.STRING).payloadMarshaller(MarshallingType.JSON_VALUE, SimpleTypeRpcV2CborMarshallers.STRING).payloadMarshaller(MarshallingType.INTEGER, SimpleTypeRpcV2CborMarshallers.INTEGER).payloadMarshaller(MarshallingType.LONG, SimpleTypeRpcV2CborMarshallers.LONG).payloadMarshaller(MarshallingType.SHORT, SimpleTypeRpcV2CborMarshallers.SHORT).payloadMarshaller(MarshallingType.DOUBLE, SimpleTypeRpcV2CborMarshallers.DOUBLE).payloadMarshaller(MarshallingType.BIG_INTEGER, SimpleTypeRpcV2CborMarshallers.BIG_INTEGER).payloadMarshaller(MarshallingType.FLOAT, SimpleTypeRpcV2CborMarshallers.FLOAT).payloadMarshaller(MarshallingType.BIG_DECIMAL, SimpleTypeRpcV2CborMarshallers.BIG_DECIMAL).payloadMarshaller(MarshallingType.BOOLEAN, SimpleTypeRpcV2CborMarshallers.BOOLEAN).payloadMarshaller(MarshallingType.DATE, SimpleTypeRpcV2CborMarshallers.DATE).payloadMarshaller(MarshallingType.BYTE_BUFFER, SimpleTypeRpcV2CborMarshallers.BYTE_BUFFER).payloadMarshaller(MarshallingType.STRUCTURED, SimpleTypeRpcV2CborMarshallers.STRUCTURED).payloadMarshaller(MarshallingType.LIST, SimpleTypeRpcV2CborMarshallers.LIST).payloadMarshaller(MarshallingType.MAP, SimpleTypeRpcV2CborMarshallers.MAP).payloadMarshaller(MarshallingType.NULL, SimpleTypeRpcV2CborMarshallers.NULL).headerMarshaller(MarshallingType.STRING, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.STRING)).headerMarshaller(MarshallingType.JSON_VALUE, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.JSON_VALUE)).headerMarshaller(MarshallingType.INTEGER, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.INTEGER)).headerMarshaller(MarshallingType.LONG, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.LONG)).headerMarshaller(MarshallingType.DOUBLE, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.DOUBLE)).headerMarshaller(MarshallingType.BIG_INTEGER, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.BIG_INTEGER)).headerMarshaller(MarshallingType.FLOAT, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.FLOAT)).headerMarshaller(MarshallingType.BOOLEAN, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.BOOLEAN)).headerMarshaller(MarshallingType.DATE, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.DATE)).headerMarshaller(MarshallingType.NULL, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.NULL)).queryParamMarshaller(MarshallingType.STRING, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.STRING)).queryParamMarshaller(MarshallingType.INTEGER, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.INTEGER)).queryParamMarshaller(MarshallingType.LONG, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.LONG)).queryParamMarshaller(MarshallingType.SHORT, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.SHORT)).queryParamMarshaller(MarshallingType.DOUBLE, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.DOUBLE)).queryParamMarshaller(MarshallingType.BIG_INTEGER, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.BIG_INTEGER)).queryParamMarshaller(MarshallingType.FLOAT, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.FLOAT)).queryParamMarshaller(MarshallingType.BOOLEAN, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.BOOLEAN)).queryParamMarshaller(MarshallingType.DATE, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.DATE)).queryParamMarshaller(MarshallingType.LIST, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.LIST)).queryParamMarshaller(MarshallingType.MAP, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.MAP)).queryParamMarshaller(MarshallingType.NULL, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.NULL)).pathParamMarshaller(MarshallingType.STRING, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.STRING)).pathParamMarshaller(MarshallingType.INTEGER, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.INTEGER)).pathParamMarshaller(MarshallingType.LONG, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.LONG)).pathParamMarshaller(MarshallingType.NULL, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.NULL)).greedyPathParamMarshaller(MarshallingType.STRING, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.STRING)).greedyPathParamMarshaller(MarshallingType.NULL, RpcV2CborProtocolMarshaller.unsupportedMarshaller(MarshallingType.NULL)).build();
    }

    public static <T> RpcV2CborMarshaller<T> unsupportedMarshaller(MarshallingType<T> marshallingType) {
        return new RpcV2CborMarshaller<T>(){

            @Override
            public void marshall(T val, RpcV2CborMarshallerContext context, MarshallingInfo<T> marshallingInfo) {
                throw new IllegalStateException("HttpBindings are not supported in rpcv2cbor, unable to marshall: " + marshallingInfo);
            }
        };
    }

    @Override
    public void startMarshalling() {
        if (!this.hasExplicitPayloadMember) {
            this.rpcv2cborGenerator.writeStartObject();
        }
    }

    public <V> void marshall(V val, MarshallingInfo<V> marshallingInfo) {
        this.doMarshall(this.resolveValue(val, marshallingInfo), marshallingInfo);
    }

    private <V> V resolveValue(V val, MarshallingInfo<V> marshallingInfo) {
        return val == null && marshallingInfo.defaultValueSupplier() != null ? marshallingInfo.defaultValueSupplier().get() : val;
    }

    private <V> void doMarshall(V val, MarshallingInfo<V> marshallingInfo) {
        if (marshallingInfo.isBinary()) {
            this.marshallBinaryPayload(val);
        } else {
            this.marshallerRegistry.getMarshaller(marshallingInfo.marshallLocation(), marshallingInfo.marshallingType(), val).marshall(val, this.marshallerContext, marshallingInfo);
        }
    }

    private void marshallBinaryPayload(Object val) {
        if (val instanceof ByteBuffer) {
            this.request.setContent(BinaryUtils.toStream((ByteBuffer)val));
        } else if (val instanceof InputStream) {
            this.request.setContent((InputStream)val);
        }
    }

    @Override
    public Request<OrigRequest> finishMarshalling() {
        if (this.request.getContent() == null) {
            if (!this.hasExplicitPayloadMember) {
                this.rpcv2cborGenerator.writeEndObject();
            }
            byte[] content = this.rpcv2cborGenerator.getBytes();
            this.request.setContent(new ByteArrayInputStream(content));
            if (content.length > 0) {
                this.request.addHeader("Content-Length", Integer.toString(content.length));
            }
        }
        if (!this.request.getHeaders().containsKey("Content-Type") && this.contentType != null && this.request.getHeaders().containsKey("Content-Length")) {
            this.request.addHeader("Content-Type", this.contentType);
        }
        if (this.isAwsQueryCompatible) {
            this.request.addHeader("x-amzn-query-mode", "true");
        }
        return this.request;
    }
}

